/* Copyright 2021-2023 Ethan Halsall. This file is part of wasm-audio-decoders. https://github.com/eshaz/wasm-audio-decoders */
var t,s;t=this,s=function(t,s){const i=(t,s=4294967295,i=79764919)=>{const e=new Int32Array(256);let r,n,h,o=s;for(r=0;r<256;r++){for(h=r<<24,n=8;n>0;--n)h=2147483648&h?h<<1^i:h<<1;e[r]=h}for(r=0;r<t.length;r++)o=o<<8^e[255&(o>>24^t[r])];return o},e=(t,s=i)=>{const e=t=>new Uint8Array(t.length/2).map(((s,i)=>parseInt(t.substring(2*i,2*(i+1)),16))),r=t=>e(t)[0],n=new Map;[,8364,,8218,402,8222,8230,8224,8225,710,8240,352,8249,338,,381,,,8216,8217,8220,8221,8226,8211,8212,732,8482,353,8250,339,,382,376].forEach(((t,s)=>n.set(t,s)));const h=new Uint8Array(t.length);let o,a,l,c=!1,u=0,U=42,d=t.length>13&&"dynEncode"===t.substring(0,9),f=0;d&&(f=11,a=r(t.substring(9,f)),a<=1&&(f+=2,U=r(t.substring(11,f))),1===a&&(f+=8,l=(t=>new DataView(e(t).buffer).getInt32(0,!0))(t.substring(13,f))));const p=256-U;for(let i=f;i<t.length;i++)if(o=t.charCodeAt(i),61!==o||c){if(92===o&&i<t.length-5&&d){const s=t.charCodeAt(i+1);117!==s&&85!==s||(o=parseInt(t.substring(i+2,i+6),16),i+=5)}if(o>255){const t=n.get(o);t&&(o=t+127)}c&&(c=!1,o-=64),h[u++]=o<U&&o>0?o+p:o-U}else c=!0;const y=h.subarray(0,u);if(d&&1===a){const t=s(y);if(t!==l){const s="Decode failed crc32 validation";throw console.error("`simple-yenc`\n",s+"\n","Expected: "+l+"; Got: "+t+"\n","Visit https://github.com/eshaz/simple-yenc for more information"),Error(s)}}return y};function r(){const t=Uint8Array,s=Float32Array;r.t||Object.defineProperties(r,{t:{value:new WeakMap},o:{value(t,s){r.t.set(t,Promise.resolve(s))}},u:{value(t,s){let i=r.t.get(t);return i||(s?i=WebAssembly.compile(e(s)):(s=t.U,i=r.p(s).then((t=>WebAssembly.compile(t)))),r.t.set(t,i)),i}},M:{value(t,i){let e=new s(i),r=0,n=0;for(;r<t.length;)e.set(t[r],n),n+=t[r++].length;return e}},T:{value:(t,s,i,e,r)=>({A:t,channelData:s,samplesDecoded:i,sampleRate:e,bitDepth:r})},O:{value(t,s,i,e,n,h){let o,a,l=[];for(o=0;o<i;o++){const t=[];for(a=0;a<s.length;)t.push(s[a++][o]||[]);l.push(r.M(t,e))}return r.T(t,l,e,n,h)}},p:{value(s){return s=e(s),new Promise((i=>{const e=String.raw`dynEncode0114db91da9bu*ttt$#U¤¤U¤¤3yzzss|yusvuyÚ&4<054<,5T44^T44<(6U~J(44< ~A544U~6J0444545 444J0444J,4U4UÒ7U454U4Z4U4U^/6545T4T44BU~64CU~O4U54U~5 U5T4B4Z!4U~5U5U5T4U~6U4ZTU5U5T44~4O4U2ZTU5T44Z!4B6T44U~64B6U~O44U~4O4U~54U~5 44~C4~54U~5 44~5454U4B6Ub!444~UO4U~5 U54U4ZTU#44U$464<4~B6^4<444~U~B4U~54U544~544~U5 µUä#UJUè#5TT4U0ZTTUX5U5T4T4Uà#~4OU4U $~C4~54U~5 T44$6U\!TTT4UaT4<6T4<64<Z!44~4N4<U~5 4UZ!4U±_TU#44UU6UÔ~B$544$6U\!4U6U¤#~B44Uä#~B$~64<6_TU#444U~B~6~54<Y!44<_!T4Y!4<64~444~AN44<U~6J4U5 44J4U[!U#44UO4U~54U~5 U54 7U6844J44J 4UJ4UJ04VK(44<J44<J$4U´~54U~5 4U¤~5!TTT4U$5"U5TTTTTTT4U$"4VK,U54<(6U~64<$6_!4< 64~6A54A544U~6#J(U54A4U[!44J(44#~A4U6UUU[!4464~64_!4<64~54<6T4<4]TU5 T4Y!44~44~AN4U~54U~54U5 44J(44J UÄA!U5U#UôJU"UÔJU#UÔ"JU#U´"JT4U´ZTU5T4UôZTU5T4UDZTU5T4U$[T44~UO4U~5 UÔUô4U~U´$.U5T4UP[T4U~4~UO4U~5 U#<U#<4U~U2$.UÄUN 44 ~UO4U~5 44!~UO4U~5 4U~4~UO4U~5 44J44J(U5 44U¤~J@44Uä~J<44UD~J844U~J44U$54U$5U54U$54U1^4U1^!4U~54U~5U54U~6U4U^/65T4T4U$54U~4BU~4O4U54U~5 UU'464U'_/54UU~5T4T4U~4BU~UO4U54U~5 U54Uä~4U¤~4U~U'$!44~5U5T44\T44U<~$6U\!4U#aT4U~4U~4O4U~5 U5U5U5TTT4U$"4YTU5 4U4~C5U5 U5U5444$4~64~\TU5 4U~4U~5T4Y!44O4U~54U~54U5 4CYTU5 4Uä~4U¤~4U~4$6TU54U\!44Bæ4Bä~[!4U~4UD~4U~4U~4$6TU54U\!44B4B~[!44U<~4U4~$5 4U"U#$544"Y!454U^!44<J44<(J454U~84­UN!#%'+/37?GOWgw·×÷Uä;U9$%& !"#`;r.u(r,e).then((t=>WebAssembly.instantiate(t,{}))).then((({exports:e})=>{const r=new Map(Object.entries(e)),n=r.get("puff"),h=r.get("memory").buffer,o=new t(h),a=new DataView(h);let l=r.get("__heap_base");const c=s.length,u=l;l+=4,a.setInt32(u,c,!0);const U=l;l+=c,o.set(s,U);const d=l;l+=4,a.setInt32(d,o.byteLength-l,!0),n(l,d,U,u),i(o.slice(l,l+a.getInt32(d,!0)))}))}))}}}),Object.defineProperty(this,"U",{enumerable:!0,get:()=>this.$}),this.v=(t,s,i)=>{let e=[],r=0;for(;r<s;)e.push(t.slice(r*i,r++*i+i));return e},this.C=(t,s,i=!0)=>{const e=this.$.S(s.BYTES_PER_ELEMENT*t);return i&&this.F.add(e),{_:e,J:t,L:new s(this.$.N,e,t)}},this.free=()=>{this.F.forEach((t=>{this.$.free(t)})),this.F.clear()},this.P=t=>{const s=[],i=new Uint8Array(this.$.N);for(let e=i[t];0!==e;e=i[++t])s.push(e);return String.fromCharCode.apply(null,s)},this.B=(t,s,i,e,r,n)=>{t.push({message:s,frameLength:i,frameNumber:e,inputBytes:r,outputSamples:n})},this.instantiate=(t,s)=>(s&&r.o(t,s),this.$=new t(r).instantiate(),this.F=new Set,this.$.ready.then((()=>this)))}class n extends((()=>globalThis.Worker||s)()){constructor(t,s,i,e){r.t||new r;let n=r.t.get(i);if(!n){let t,s="text/javascript",h=`'use strict';(${""+((t,s,i)=>{let e,r,n=new Promise((t=>{r=t}));self.onmessage=({data:{id:h,command:o,data:a}})=>{let l,c=n,u={id:h};"init"===o?(Object.defineProperties(t,{I:{value:s},D:{value:i},module:{value:a.module},W:{value:!0}}),e=new t(a.options),r()):"free"===o?e.free():"ready"===o?c=c.then((()=>e.ready)):"reset"===o?c=c.then((()=>e.reset())):(Object.assign(u,e[o](Array.isArray(a)?a.map((t=>new Uint8Array(t))):new Uint8Array(a))),l=u.channelData?u.channelData.map((t=>t.buffer)):[]),c.then((()=>self.postMessage(u,l)))}})})(${i}, ${r}, ${e})`;try{t=void 0!==process.versions.node}catch{}n=t?`data:${s};base64,${Buffer.from(h).toString("base64")}`:URL.createObjectURL(new Blob([h],{type:s})),r.t.set(i,n)}super(n,{name:s}),this.R=Number.MIN_SAFE_INTEGER,this.V=new Map,this.onmessage=({data:t})=>{const{id:s,...i}=t;this.V.get(s)(i),this.V.delete(s)},new e(r).u().then((s=>{this.Z("init",{module:s,options:t})}))}async Z(t,s){return new Promise((i=>{this.postMessage({command:t,id:this.R,data:s}),this.V.set(this.R++,i)}))}get ready(){return this.Z("ready")}async free(){await this.Z("free").finally((()=>{this.terminate()}))}async reset(){await this.Z("reset")}}const h=(t,s)=>{Object.defineProperty(t,"name",{value:s})},o=Symbol,a=(()=>{const t="left",s="center",i="right";return["","front ","side ","rear "].map((e=>[[t,i],[t,i,s],[t,s,i],[s,t,i],[s]].flatMap((t=>t.map((t=>e+t)).join(", ")))))})(),l="LFE",c="monophonic (mono)",u="stereo",U="surround",d=(t,...s)=>`${[c,u,"linear "+U,"quadraphonic","5.0 "+U,"5.1 "+U,"6.1 "+U,"7.1 "+U][t-1]} (${s.join(", ")})`,f=[c,d(2,a[0][0]),d(3,a[0][2]),d(4,a[1][0],a[3][0]),d(5,a[1][2],a[3][0]),d(6,a[1][2],a[3][0],l),d(7,a[1][2],a[2][0],a[3][4],l),d(8,a[1][2],a[2][0],a[3][0],l)],p=48e3,y=44100,m=32e3,g=24e3,w=22050,M=16e3,b=8e3,T="absoluteGranulePosition",A="bandwidth",O="bitDepth",$="bitrate",v=$+"Maximum",x=$+"Minimum",C=$+"Nominal",S="buffer",F=S+"Fullness",j="codec",_=j+"Frames",k="coupledStreamCount",J="crc",L=J+"16",N=J+"32",P="data",B="description",I="duration",E="emphasis",D="hasOpusPadding",W="header",R="isContinuedPacket",V="isCopyrighted",Z="isFirstPage",G="isHome",q="isLastPage",Q="isOriginal",H="isPrivate",X="isVbr",Y="layer",z="length",K="mode",tt=K+"Extension",st="mpeg",it=st+"Version",et="numberAACFrames",rt="outputGain",nt="preSkip",ht="profile",ot=o(),at="protection",lt="segments",ct="subarray",ut="version",Ut="vorbis",dt=Ut+"Comments",ft=Ut+"Setup",pt="block",yt=pt+"ingStrategy",mt=o(),gt=pt+"Size",wt=pt+"size0",Mt=pt+"size1",bt=o(),Tt="channel",At=Tt+"MappingFamily",Ot=Tt+"MappingTable",$t=Tt+"Mode",vt=o(),xt=Tt+"s",Ct="copyright",St=Ct+"Id",Ft=Ct+"IdStart",jt="frame",_t=jt+"Count",kt=jt+"Length",Jt="Number",Lt=jt+Jt,Nt=jt+"Padding",Pt=jt+"Size",Bt="Rate",It="inputSample"+Bt,Et="page",Dt=Et+"Checksum",Wt=o(),Rt=Et+"SegmentTable",Vt=Et+"Sequence"+Jt,Zt="sample",Gt=Zt+Jt,qt=Zt+Bt,Qt=o(),Ht=Zt+"s",Xt="stream",Yt=Xt+"Count",zt=Xt+"Info",Kt=Xt+"Serial"+Jt,ts=Xt+"StructureVersion",ss="total",is=ss+"BytesOut",es=ss+"Duration",rs=ss+"Samples",ns=o(),hs=o(),os=o(),as=o(),ls=o(),cs=o(),us=o(),Us=o(),ds=o(),fs=o(),ps=o(),ys=o(),ms=o(),gs=o(),ws=o(),Ms=o(),bs=o(),Ts=o(),As=Uint8Array,Os=DataView,$s="reserved",vs="bad",xs="free",Cs="none",Ss="16bit CRC",Fs=(t,s,i)=>{for(let e=0;e<t[z];e++){let r=s(e);for(let t=8;t>0;t--)r=i(r);t[e]=r}return t},js=Fs(new As(256),(t=>t),(t=>128&t?7^t<<1:t<<1)),_s=[Fs(new Uint16Array(256),(t=>t<<8),(t=>t<<1^(32768&t?32773:0)))],ks=[Fs(new Uint32Array(256),(t=>t),(t=>t>>>1^3988292384*(1&t)))];for(let $e=0;$e<15;$e++){_s.push(new Uint16Array(256)),ks.push(new Uint32Array(256));for(let t=0;t<=255;t++)_s[$e+1][t]=_s[0][_s[$e][t]>>>8]^_s[$e][t]<<8,ks[$e+1][t]=ks[$e][t]>>>8^ks[0][255&ks[$e][t]]}const Js=t=>{const s=t[z],i=s-16;let e=0,r=0;for(;r<=i;)e=ks[15][255&(t[r++]^e)]^ks[14][255&(t[r++]^e>>>8)]^ks[13][255&(t[r++]^e>>>16)]^ks[12][t[r++]^e>>>24]^ks[11][t[r++]]^ks[10][t[r++]]^ks[9][t[r++]]^ks[8][t[r++]]^ks[7][t[r++]]^ks[6][t[r++]]^ks[5][t[r++]]^ks[4][t[r++]]^ks[3][t[r++]]^ks[2][t[r++]]^ks[1][t[r++]]^ks[0][t[r++]];for(;r!==s;)e=ks[0][255&(e^t[r++])]^e>>>8;return~e},Ls=(...t)=>{const s=new As(t.reduce(((t,s)=>t+s[z]),0));return t.reduce(((t,i)=>(s.set(i,t),t+i[z])),0),s},Ns=t=>String.fromCharCode(...t),Ps=[0,8,4,12,2,10,6,14,1,9,5,13,3,11,7,15],Bs=t=>Ps[15&t]<<4|Ps[t>>4];class Is{constructor(t){this.G=t,this.q=8*t[z]}set position(t){this.q=t}get position(){return this.q}read(t){const s=Math.floor(this.q/8),i=this.q%8;return this.q-=t,(Bs(this.G[s-1])<<8)+Bs(this.G[s])>>7-i&255}}class Es{constructor(t,s){this.H=t,this.X=s,this[ws]()}[Ms](){this.Y=!0}[ws](){this.K=new Map,this.tt=new WeakMap,this.st=!1,this.it=!1,this.et=null,this.Y=!1}[gs](t,s){if(this.X){this.et!==t&&(this.et=t,this.it=!0);const i=this.tt.get(this.K.get(this.rt));this.it&&i&&this.X({nt:t,...i},s),this.it=!1}}[ds](t){const s=this.K.get(t);return s&&this.ht(t),s}[fs](t,s,i){this.Y&&(this.st||(this.H({...s}),this.st=!0),this.ht(t),this.K.set(t,s),this.tt.set(s,i))}ht(t){this.X&&t!==this.rt&&(this.it=!0,this.rt=t)}}const Ds=new WeakMap,Ws=new WeakMap;class Rs{constructor(t,s){this.ot=t,this.K=s}*[us](){let t;for(;;){if(t=yield*this.lt[ps](this.ot,this.K,0),t)return t;this.ot[hs](1)}}*[Us](t){let s=yield*this[us]();const i=Ws.get(s)[z];if(t||this.ot.ct||(yield*this.ut[ds](this.ot,this.K,i)))return this.K[Ms](),this.ot[hs](i),this.ot[as](s),s;this.ot[ls](`Missing ${jt} at ${i} bytes from current position.`,`Dropping current ${jt} and trying again.`),this.K[ws](),this.ot[hs](1)}}class Vs{constructor(t,s){Ws.set(this,{[W]:t}),this[P]=s}}class Zs extends Vs{static*[ps](t,s,i,e,r){const n=yield*t[ds](i,e,r);if(n){const t=Ds.get(n)[kt],e=Ds.get(n)[Ht];return new s(n,(yield*i[ns](t,r))[ct](0,t),e)}return null}constructor(t,s,i){super(t,s),this[W]=t,this[Ht]=i,this[I]=i/t[qt]*1e3,this[Lt]=null,this[is]=null,this[rs]=null,this[es]=null,Ws.get(this)[z]=s[z]}}const Gs="unsynchronizationFlag",qs="extendedHeaderFlag",Qs="experimentalFlag",Hs="footerPresent";class Xs{static*Ut(t,s,i){const e={};let r=yield*t[ns](3,i);if(73!==r[0]||68!==r[1]||51!==r[2])return null;if(r=yield*t[ns](10,i),e[ut]=`id3v2.${r[3]}.${r[4]}`,15&r[5])return null;if(e[Gs]=!!(128&r[5]),e[qs]=!!(64&r[5]),e[Qs]=!!(32&r[5]),e[Hs]=!!(16&r[5]),128&r[6]||128&r[7]||128&r[8]||128&r[9])return null;const n=r[6]<<21|r[7]<<14|r[8]<<7|r[9];return e[z]=10+n,new Xs(e)}constructor(t){this[ut]=t[ut],this[Gs]=t[Gs],this[qs]=t[qs],this[Qs]=t[Qs],this[Hs]=t[Hs],this[z]=t[z]}}class Ys{constructor(t){Ds.set(this,t),this[O]=t[O],this[$]=null,this[xt]=t[xt],this[$t]=t[$t],this[qt]=t[qt]}}const zs={0:[xs,xs,xs,xs,xs],16:[32,32,32,32,8],240:[vs,vs,vs,vs,vs]},Ks=(t,s,i)=>8*((t+i)%s+s)*(1<<(t+i)/s)-8*s*(s/8|0);for(let $e=2;$e<15;$e++)zs[$e<<4]=[32*$e,Ks($e,4,0),Ks($e,4,-1),Ks($e,8,4),Ks($e,8,0)];const ti="bands ",si=" to 31",ii={0:ti+4+si,16:ti+8+si,32:ti+12+si,48:ti+16+si},ei="bitrateIndex",ri="v2",ni="v1",hi="Intensity stereo ",oi=", MS stereo ",ai="on",li="off",ci={0:hi+li+oi+li,16:hi+ai+oi+li,32:hi+li+oi+ai,48:hi+ai+oi+ai},ui={0:{[B]:$s},2:{[B]:"Layer III",[Nt]:1,[tt]:ci,[ni]:{[ei]:2,[Ht]:1152},[ri]:{[ei]:4,[Ht]:576}},4:{[B]:"Layer II",[Nt]:1,[tt]:ii,[Ht]:1152,[ni]:{[ei]:1},[ri]:{[ei]:4}},6:{[B]:"Layer I",[Nt]:4,[tt]:ii,[Ht]:384,[ni]:{[ei]:0},[ri]:{[ei]:3}}},Ui="MPEG Version ",di="ISO/IEC ",fi={0:{[B]:Ui+"2.5 (later extension of MPEG 2)",[Y]:ri,[qt]:{0:11025,4:12e3,8:b,12:$s}},8:{[B]:$s},16:{[B]:`${Ui}2 (${di}13818-3)`,[Y]:ri,[qt]:{0:w,4:g,8:M,12:$s}},24:{[B]:`${Ui}1 (${di}11172-3)`,[Y]:ni,[qt]:{0:y,4:p,8:m,12:$s}},length:z},pi={0:Ss,1:Cs},yi={0:Cs,1:"50/15 ms",2:$s,3:"CCIT J.17"},mi={0:{[xt]:2,[B]:u},64:{[xt]:2,[B]:"joint "+u},128:{[xt]:2,[B]:"dual channel"},192:{[xt]:1,[B]:c}};class gi extends Ys{static*[ds](t,s,i){const e={},r=yield*Xs.Ut(t,s,i);r&&(yield*t[ns](r[z],i),t[hs](r[z]));const n=yield*t[ns](4,i),h=Ns(n[ct](0,4)),o=s[ds](h);if(o)return new gi(o);if(255!==n[0]||n[1]<224)return null;const a=fi[24&n[1]];if(a[B]===$s)return null;const l=6&n[1];if(ui[l][B]===$s)return null;const c={...ui[l],...ui[l][a[Y]]};if(e[it]=a[B],e[Y]=c[B],e[Ht]=c[Ht],e[at]=pi[1&n[1]],e[z]=4,e[$]=zs[240&n[2]][c[ei]],e[$]===vs)return null;if(e[qt]=a[qt][12&n[2]],e[qt]===$s)return null;if(e[Nt]=2&n[2]&&c[Nt],e[H]=!!(1&n[2]),e[kt]=Math.floor(125*e[$]*e[Ht]/e[qt]+e[Nt]),!e[kt])return null;const u=192&n[3];if(e[$t]=mi[u][B],e[xt]=mi[u][xt],e[tt]=c[tt][48&n[3]],e[V]=!!(8&n[3]),e[Q]=!!(4&n[3]),e[E]=yi[3&n[3]],e[E]===$s)return null;e[O]=16;{const{length:t,frameLength:i,dt:r,...n}=e;s[fs](h,e,n)}return new gi(e)}constructor(t){super(t),this[$]=t[$],this[E]=t[E],this[Nt]=t[Nt],this[V]=t[V],this[Q]=t[Q],this[H]=t[H],this[Y]=t[Y],this[tt]=t[tt],this[it]=t[it],this[at]=t[at]}}class wi extends Zs{static*[ps](t,s,i){return yield*super[ps](gi,wi,t,s,i)}constructor(t,s,i){super(t,s,i)}}class Mi extends Rs{constructor(t,s,i){super(t,s),this.lt=wi,this.ut=gi,i(this[j])}get[j](){return st}*[ys](){return yield*this[Us]()}}const bi={0:"MPEG-4",8:"MPEG-2"},Ti={0:"valid",2:vs,4:vs,6:vs},Ai={0:Ss,1:Cs},Oi={0:"AAC Main",64:"AAC LC (Low Complexity)",128:"AAC SSR (Scalable Sample Rate)",192:"AAC LTP (Long Term Prediction)"},$i={0:96e3,4:88200,8:64e3,12:p,16:y,20:m,24:g,28:w,32:M,36:12e3,40:11025,44:b,48:7350,52:$s,56:$s,60:"frequency is written explicitly"},vi={0:{[xt]:0,[B]:"Defined in AOT Specific Config"},64:{[xt]:1,[B]:c},128:{[xt]:2,[B]:d(2,a[0][0])},192:{[xt]:3,[B]:d(3,a[1][3])},256:{[xt]:4,[B]:d(4,a[1][3],a[3][4])},320:{[xt]:5,[B]:d(5,a[1][3],a[3][0])},384:{[xt]:6,[B]:d(6,a[1][3],a[3][0],l)},448:{[xt]:8,[B]:d(8,a[1][3],a[2][0],a[3][0],l)}};class xi extends Ys{static*[ds](t,s,i){const e={},r=yield*t[ns](7,i),n=Ns([r[0],r[1],r[2],252&r[3]|3&r[6]]),h=s[ds](n);if(h)Object.assign(e,h);else{if(255!==r[0]||r[1]<240)return null;if(e[it]=bi[8&r[1]],e[Y]=Ti[6&r[1]],e[Y]===vs)return null;const t=1&r[1];e[at]=Ai[t],e[z]=t?7:9,e[ot]=192&r[2],e[Qt]=60&r[2];const i=2&r[2];if(e[ht]=Oi[e[ot]],e[qt]=$i[e[Qt]],e[qt]===$s)return null;e[H]=!!i,e[vt]=448&(r[2]<<8|r[3]),e[$t]=vi[e[vt]][B],e[xt]=vi[e[vt]][xt],e[Q]=!!(32&r[3]),e[G]=!!(8&r[3]),e[St]=!!(8&r[3]),e[Ft]=!!(4&r[3]),e[O]=16,e[Ht]=1024,e[et]=3&r[6];{const{length:t,ft:i,yt:r,gt:h,frameLength:o,dt:a,wt:l,...c}=e;s[fs](n,e,c)}}if(e[kt]=8191&(r[3]<<11|r[4]<<3|r[5]>>5),!e[kt])return null;const o=2047&(r[5]<<6|r[6]>>2);return e[F]=2047===o?"VBR":o,new xi(e)}constructor(t){super(t),this[St]=t[St],this[Ft]=t[Ft],this[F]=t[F],this[G]=t[G],this[Q]=t[Q],this[H]=t[H],this[Y]=t[Y],this[z]=t[z],this[it]=t[it],this[et]=t[et],this[ht]=t[ht],this[at]=t[at]}get Mt(){const t=Ds.get(this),s=t[ot]+64<<5|t[Qt]<<5|t[vt]>>3,i=new As(2);return new Os(i[S]).setUint16(0,s,!1),i}}class Ci extends Zs{static*[ps](t,s,i){return yield*super[ps](xi,Ci,t,s,i)}constructor(t,s,i){super(t,s,i)}}class Si extends Rs{constructor(t,s,i){super(t,s),this.lt=Ci,this.ut=xi,i(this[j])}get[j](){return"aac"}*[ys](){return yield*this[Us]()}}class Fi extends Zs{static bt(t){return(t[t[z]-2]<<8)+t[t[z]-1]}static[Ts](t){const s=Fi.bt(t),i=(t=>{const s=t[z],i=s-16;let e=0,r=0;for(;r<=i;)e^=t[r++]<<8|t[r++],e=_s[15][e>>8]^_s[14][255&e]^_s[13][t[r++]]^_s[12][t[r++]]^_s[11][t[r++]]^_s[10][t[r++]]^_s[9][t[r++]]^_s[8][t[r++]]^_s[7][t[r++]]^_s[6][t[r++]]^_s[5][t[r++]]^_s[4][t[r++]]^_s[3][t[r++]]^_s[2][t[r++]]^_s[1][t[r++]]^_s[0][t[r++]];for(;r!==s;)e=(255&e)<<8^_s[0][e>>8^t[r++]];return e})(t[ct](0,-2));return s===i}constructor(t,s,i){s[zt]=i,s[L]=Fi.bt(t),super(s,t,Ds.get(s)[Ht])}}const ji="get from STREAMINFO metadata block",_i={0:"Fixed",1:"Variable"},ki={0:$s,16:192};for(let $e=2;$e<16;$e++)ki[$e<<4]=$e<6?576*2**($e-2):2**$e;const Ji={0:ji,1:88200,2:176400,3:192e3,4:b,5:M,6:w,7:g,8:m,9:y,10:p,11:96e3,15:vs},Li={0:{[xt]:1,[B]:c},16:{[xt]:2,[B]:d(2,a[0][0])},32:{[xt]:3,[B]:d(3,a[0][1])},48:{[xt]:4,[B]:d(4,a[1][0],a[3][0])},64:{[xt]:5,[B]:d(5,a[1][1],a[3][0])},80:{[xt]:6,[B]:d(6,a[1][1],l,a[3][0])},96:{[xt]:7,[B]:d(7,a[1][1],l,a[3][4],a[2][0])},112:{[xt]:8,[B]:d(8,a[1][1],l,a[3][0],a[2][0])},128:{[xt]:2,[B]:u+" (left, diff)"},144:{[xt]:2,[B]:u+" (diff, right)"},160:{[xt]:2,[B]:u+" (avg, diff)"},176:$s,192:$s,208:$s,224:$s,240:$s},Ni={0:ji,2:8,4:12,6:$s,8:16,10:20,12:24,14:$s};class Pi extends Ys{static Tt(t){if(t[0]>254)return null;if(t[0]<128)return{value:t[0],length:1};let s=1;for(let n=64;n&t[0];n>>=1)s++;let i=s-1,e=0,r=0;for(;i>0;r+=6,i--){if(128!=(192&t[i]))return null;e|=(63&t[i])<<r}return e|=(t[i]&127>>s)<<r,{value:e,length:s}}static[bs](t,s){const i={*[ns](){return t}};return Pi[ds](i,s,0).next().value}static*[ds](t,s,i){let e=yield*t[ns](6,i);if(255!==e[0]||248!==e[1]&&249!==e[1])return null;const r={},n=Ns(e[ct](0,4)),h=s[ds](n);if(h)Object.assign(r,h);else{if(r[mt]=1&e[1],r[yt]=_i[r[mt]],r[bt]=240&e[2],r[Qt]=15&e[2],r[gt]=ki[r[bt]],r[gt]===$s)return null;if(r[qt]=Ji[r[Qt]],r[qt]===vs)return null;if(1&e[3])return null;const t=Li[240&e[3]];if(t===$s)return null;if(r[xt]=t[xt],r[$t]=t[B],r[O]=Ni[14&e[3]],r[O]===$s)return null}r[z]=5,e=yield*t[ns](r[z]+8,i);const o=Pi.Tt(e[ct](4));if(!o)return null;if(r[mt]?r[Gt]=o.value:r[Lt]=o.value,r[z]+=o[z],96===r[bt]?(e[z]<r[z]&&(e=yield*t[ns](r[z],i)),r[gt]=e[r[z]-1]+1,r[z]+=1):112===r[bt]&&(e[z]<r[z]&&(e=yield*t[ns](r[z],i)),r[gt]=(e[r[z]-1]<<8)+e[r[z]]+1,r[z]+=2),r[Ht]=r[gt],12===r[Qt]?(e[z]<r[z]&&(e=yield*t[ns](r[z],i)),r[qt]=1e3*e[r[z]-1],r[z]+=1):13===r[Qt]?(e[z]<r[z]&&(e=yield*t[ns](r[z],i)),r[qt]=(e[r[z]-1]<<8)+e[r[z]],r[z]+=2):14===r[Qt]&&(e[z]<r[z]&&(e=yield*t[ns](r[z],i)),r[qt]=10*((e[r[z]-1]<<8)+e[r[z]]),r[z]+=2),e[z]<r[z]&&(e=yield*t[ns](r[z],i)),r[J]=e[r[z]-1],r[J]!==(t=>{let s=0;const i=t[z];for(let e=0;e!==i;e++)s=js[s^t[e]];return s})(e[ct](0,r[z]-1)))return null;if(!h){const{At:t,frameNumber:i,Ot:e,dt:h,gt:o,$t:a,vt:l,length:c,...u}=r;s[fs](n,r,u)}return new Pi(r)}constructor(t){super(t),this[L]=null,this[yt]=t[yt],this[gt]=t[gt],this[Lt]=t[Lt],this[Gt]=t[Gt],this[zt]=null}}class Bi extends Rs{constructor(t,s,i){super(t,s),this.lt=Fi,this.ut=Pi,i(this[j])}get[j](){return"flac"}*xt(t){const s=yield*this.ot[ns](2,0),i=s[z]-2;for(;t<i;){if(255===s[t]){const i=s[t+1];if(248===i||249===i)break;255!==i&&t++}t++}return t}*[ys](){for(;;){const t=yield*Pi[ds](this.ot,this.K,0);if(t){let s=Ds.get(t)[z]+2;for(;s<=524288;){if(this.ot.ct||(yield*Pi[ds](this.ot,this.K,s))){let i=yield*this.ot[ns](s);if(this.ot.ct||(i=i[ct](0,s)),Fi[Ts](i)){const e=new Fi(i,t);return this.K[Ms](),this.ot[hs](s),this.ot[as](e),e}}s=yield*this.xt(s+1)}this.ot[ls](`Unable to sync FLAC frame after searching ${s} bytes.`),this.ot[hs](s)}else this.ot[hs](yield*this.xt(1))}}[ms](t){return 0===t[Vt]?(this.K[Ms](),this.Ct=t[P][ct](13)):1===t[Vt]||(t[_]=Ws.get(t)[lt].map((t=>{const s=Pi[bs](t,this.K);if(s)return new Fi(t,s,this.Ct);this.ot[ls]("Failed to parse Ogg FLAC frame","Skipping invalid FLAC frame")})).filter((t=>!!t))),t}}class Ii{static*[ds](t,s,i){const e={};let r=yield*t[ns](28,i);if(79!==r[0]||103!==r[1]||103!==r[2]||83!==r[3])return null;if(e[ts]=r[4],248&r[5])return null;e[q]=!!(4&r[5]),e[Z]=!!(2&r[5]),e[R]=!!(1&r[5]);const n=new Os(As.from(r[ct](0,28))[S]);e[T]=(t=>{try{return t.getBigInt64(6,!0)}catch{const s=128&t.getUint8(13)?-1:1;let i=t.getUint32(6,!0),e=t.getUint32(10,!0);return-1===s&&(i=1+~i,e=1+~e),e>1048575&&console.warn("This platform does not support BigInt"),s*(i+e*2**32)}})(n),e[Kt]=n.getInt32(14,!0),e[Vt]=n.getInt32(18,!0),e[Dt]=n.getInt32(22,!0);const h=r[26];e[z]=h+27,r=yield*t[ns](e[z],i),e[kt]=0,e[Rt]=[],e[Wt]=As.from(r[ct](27,e[z]));for(let o=0,a=0;o<h;o++){const t=e[Wt][o];e[kt]+=t,a+=t,255===t&&o!==h-1||(e[Rt].push(a),a=0)}return new Ii(e)}constructor(t){Ds.set(this,t),this[T]=t[T],this[R]=t[R],this[Z]=t[Z],this[q]=t[q],this[Rt]=t[Rt],this[Vt]=t[Vt],this[Dt]=t[Dt],this[Kt]=t[Kt]}}class Ei extends Vs{static*[ps](t,s,i){const e=yield*Ii[ds](t,s,i);if(e){const s=Ds.get(e)[kt],i=Ds.get(e)[z],r=i+s,n=(yield*t[ns](r,0))[ct](0,r),h=n[ct](i,r);return new Ei(e,h,n)}return null}constructor(t,s,i){super(t,s),Ws.get(this)[z]=i[z],this[_]=[],this.St=i,this[T]=t[T],this[N]=t[Dt],this[I]=0,this[R]=t[R],this[Z]=t[Z],this[q]=t[q],this[Vt]=t[Vt],this[Ht]=0,this[Kt]=t[Kt]}}class Di extends Zs{constructor(t,s,i){super(s,t,i)}}const Wi={0:f.slice(0,2),1:f},Ri="SILK-only",Vi="CELT-only",Zi="Hybrid",Gi="narrowband",qi="medium-band",Qi="wideband",Hi="super-wideband",Xi="fullband",Yi={0:{[K]:Ri,[A]:Gi,[Pt]:10},8:{[K]:Ri,[A]:Gi,[Pt]:20},16:{[K]:Ri,[A]:Gi,[Pt]:40},24:{[K]:Ri,[A]:Gi,[Pt]:60},32:{[K]:Ri,[A]:qi,[Pt]:10},40:{[K]:Ri,[A]:qi,[Pt]:20},48:{[K]:Ri,[A]:qi,[Pt]:40},56:{[K]:Ri,[A]:qi,[Pt]:60},64:{[K]:Ri,[A]:Qi,[Pt]:10},72:{[K]:Ri,[A]:Qi,[Pt]:20},80:{[K]:Ri,[A]:Qi,[Pt]:40},88:{[K]:Ri,[A]:Qi,[Pt]:60},96:{[K]:Zi,[A]:Hi,[Pt]:10},104:{[K]:Zi,[A]:Hi,[Pt]:20},112:{[K]:Zi,[A]:Xi,[Pt]:10},120:{[K]:Zi,[A]:Xi,[Pt]:20},128:{[K]:Vi,[A]:Gi,[Pt]:2.5},136:{[K]:Vi,[A]:Gi,[Pt]:5},144:{[K]:Vi,[A]:Gi,[Pt]:10},152:{[K]:Vi,[A]:Gi,[Pt]:20},160:{[K]:Vi,[A]:Qi,[Pt]:2.5},168:{[K]:Vi,[A]:Qi,[Pt]:5},176:{[K]:Vi,[A]:Qi,[Pt]:10},184:{[K]:Vi,[A]:Qi,[Pt]:20},192:{[K]:Vi,[A]:Hi,[Pt]:2.5},200:{[K]:Vi,[A]:Hi,[Pt]:5},208:{[K]:Vi,[A]:Hi,[Pt]:10},216:{[K]:Vi,[A]:Hi,[Pt]:20},224:{[K]:Vi,[A]:Xi,[Pt]:2.5},232:{[K]:Vi,[A]:Xi,[Pt]:5},240:{[K]:Vi,[A]:Xi,[Pt]:10},248:{[K]:Vi,[A]:Xi,[Pt]:20}};class zi extends Ys{static[bs](t,s,i){const e={};if(e[xt]=t[9],e[At]=t[18],e[z]=0!==e[At]?21+e[xt]:19,t[z]<e[z])throw Error("Out of data while inside an Ogg Page");const r=3&s[0],n=3===r?2:1,h=Ns(t[ct](0,e[z]))+Ns(s[ct](0,n)),o=i[ds](h);if(o)return new zi(o);if("OpusHead"!==h.substr(0,8))return null;if(1!==t[8])return null;e[P]=As.from(t[ct](0,e[z]));const a=new Os(e[P][S]);if(e[O]=16,e[nt]=a.getUint16(10,!0),e[It]=a.getUint32(12,!0),e[qt]=p,e[rt]=a.getInt16(16,!0),e[At]in Wi&&(e[$t]=Wi[e[At]][e[xt]-1],!e[$t]))return null;0!==e[At]&&(e[Yt]=t[19],e[k]=t[20],e[Ot]=[...t[ct](21,e[xt]+21)]);const l=Yi[248&s[0]];switch(e[K]=l[K],e[A]=l[A],e[Pt]=l[Pt],r){case 0:e[_t]=1;break;case 1:case 2:e[_t]=2;break;case 3:e[X]=!!(128&s[1]),e[D]=!!(64&s[1]),e[_t]=63&s[1];break;default:return null}{const{length:t,data:s,Ft:r,...n}=e;i[fs](h,e,n)}return new zi(e)}constructor(t){super(t),this[P]=t[P],this[A]=t[A],this[At]=t[At],this[Ot]=t[Ot],this[k]=t[k],this[_t]=t[_t],this[Pt]=t[Pt],this[D]=t[D],this[It]=t[It],this[X]=t[X],this[K]=t[K],this[rt]=t[rt],this[nt]=t[nt],this[Yt]=t[Yt]}}class Ki extends Rs{constructor(t,s,i){super(t,s),this.lt=Di,this.ut=zi,i(this[j]),this.jt=null,this._t=null}get[j](){return"opus"}[ms](t){return 0===t[Vt]?(this.K[Ms](),this.jt=t[P]):1===t[Vt]||(t[_]=Ws.get(t)[lt].map((t=>{const s=zi[bs](this.jt,t,this.K);if(s){null===this._t&&(this._t=s[nt]);let i=s[Pt]*s[_t]/1e3*s[qt];return this._t>0&&(this._t-=i,i=this._t<0?-this._t:0),new Di(t,s,i)}this.ot[cs]("Failed to parse Ogg Opus Header","Not a valid Ogg Opus file")}))),t}}class te extends Zs{constructor(t,s,i){super(s,t,i)}}const se={};for(let $e=0;$e<8;$e++)se[$e+6]=2**(6+$e);class ie extends Ys{static[bs](t,s,i,e){if(t[z]<30)throw Error("Out of data while inside an Ogg Page");const r=Ns(t[ct](0,30)),n=s[ds](r);if(n)return new ie(n);const h={[z]:30};if("vorbis"!==r.substr(0,7))return null;h[P]=As.from(t[ct](0,30));const o=new Os(h[P][S]);if(h[ut]=o.getUint32(7,!0),0!==h[ut])return null;if(h[xt]=t[11],h[$t]=f[h[xt]-1]||"application defined",h[qt]=o.getUint32(12,!0),h[v]=o.getInt32(16,!0),h[C]=o.getInt32(20,!0),h[x]=o.getInt32(24,!0),h[Mt]=se[(240&t[28])>>4],h[wt]=se[15&t[28]],h[wt]>h[Mt])return null;if(1!==t[29])return null;h[O]=32,h[ft]=e,h[dt]=i;{const{length:t,data:i,version:e,kt:n,Jt:o,...a}=h;s[fs](r,h,a)}return new ie(h)}constructor(t){super(t),this[v]=t[v],this[x]=t[x],this[C]=t[C],this[wt]=t[wt],this[Mt]=t[Mt],this[P]=t[P],this[dt]=t[dt],this[ft]=t[ft]}}class ee extends Rs{constructor(t,s,i){super(t,s),this.lt=te,i(this[j]),this.jt=null,this.Lt=!1,this.Nt=null}get[j](){return Ut}[ms](t){t[_]=[];for(const s of Ws.get(t)[lt])if(1===s[0])this.K[Ms](),this.jt=t[P],this.Lt=!1;else if(3===s[0])this.Pt=s;else if(5===s[0])this.Bt=s,this.It=this.Et(s),this.Lt=!0;else if(this.Lt){const i=ie[bs](this.jt,this.K,this.Pt,this.Bt);i?t[_].push(new te(s,i,this.Dt(s,i))):this.ot[logError]("Failed to parse Ogg Vorbis Header","Not a valid Ogg Vorbis file")}return t}Dt(t,s){const i=this.It.Wt[t[0]>>1&this.It.mask]?s[Mt]:s[wt],e=null===this.Nt?0:(this.Nt+i)/4;return this.Nt=i,e}Et(t){const s=new Is(t),i={count:0,Wt:[]};for(;1&~s.read(1););let e;for(;i.count<64&&s.position>0;){Bs(s.read(8));let t=0;for(;0===s.read(8)&&t++<3;);if(4!==t){1+((126&Bs(e))>>1)!==i.count&&this.ot[ls]("vorbis derived mode count did not match actual mode count");break}e=s.read(7),i.Wt.unshift(1&e),s.position+=6,i.count++}return i.mask=(1<<Math.log2(i.count))-1,i}}class re{constructor(t,s,i){this.ot=t,this.K=s,this.Rt=i,this.Vt=new As,this.Zt=null,this.Gt=null,this.qt=null}get[j](){return this.Zt||""}Qt(t,s){this.Zt!==t&&(this.K[ws](),this.Ht=new s(this.ot,this.K,this.Rt),this.Zt=t)}Xt({data:t}){const s=Ns(t[ct](0,8));switch(s){case"fishead\0":return!1;case"OpusHead":return this.Qt("opus",Ki),!0;case/^\x7fFLAC/.test(s)&&s:return this.Qt("flac",Bi),!0;case/^\x01vorbis/.test(s)&&s:return this.Qt(Ut,ee),!0;default:return!1}}Yt(t){t[Vt]!==this.zt+1&&this.zt>1&&t[Vt]>1&&this.ot[ls]("Unexpected gap in Ogg Page Sequence Number.",`Expected: ${this.zt+1}, Got: ${t[Vt]}`),this.zt=t[Vt]}Kt(t){null===this.Gt&&(this.zt=t[Vt],this.Gt=this.Xt(t)),this.Yt(t);const s=Ws.get(t),i=Ds.get(s[W]);let e=0;if(s[lt]=i[Rt].map((s=>t[P][ct](e,e+=s))),this.Vt[z]&&(s[lt][0]=Ls(this.Vt,s[lt][0]),this.Vt=new As),255===i[Wt][i[Wt][z]-1]&&(this.Vt=Ls(this.Vt,s[lt].pop())),null!==this.qt&&(t[Ht]=Number(t[T]-this.qt)),this.qt=t[T],this.Gt){const s=this.Ht[ms](t);return this.ot[as](s),s}return t}}class ne extends Rs{constructor(t,s,i){super(t,s),this.Rt=i,this.lt=Ei,this.ut=Ii,this.ts=new Map,this.ss=null}get[j](){const t=this.ts.get(this.ss);return t?t.es:""}*[ys](){const t=yield*this[Us](!0);this.ss=t[Kt];let s=this.ts.get(this.ss);return s||(s=new re(this.ot,this.K,this.Rt),this.ts.set(this.ss,s)),t[q]&&this.ts.delete(this.ss),s.Kt(t)}}const he=()=>{};class oe{constructor(t,{rs:s,ns:i,hs:e,os:r=!1,ls:n=!0}={}){this.cs=t,this.Rt=s||he,this.H=i||he,this.X=e,this.us=r,this.Us=n?Js:he,this[ws]()}get[j](){return this.Ht?this.Ht[j]:""}[ws](){this.K=new Es(this.H,this.X),this.ds=this.fs(),this.ds.next()}*flush(){this.ct=!0;for(let t=this.ds.next();t.value;t=this.ds.next())yield t.value;this.ct=!1,this[ws]()}*ps(t){for(let s=this.ds.next(t);s.value;s=this.ds.next())yield s.value}parseAll(t){return[...this.ps(t),...this.flush()]}*fs(){if(this.cs.match(/aac/))this.Ht=new Si(this,this.K,this.Rt);else if(this.cs.match(/mpeg/))this.Ht=new Mi(this,this.K,this.Rt);else if(this.cs.match(/flac/))this.Ht=new Bi(this,this.K,this.Rt);else{if(!this.cs.match(/ogg/))throw Error("Unsupported Codec "+mimeType);this.Ht=new ne(this,this.K,this.Rt)}for(this.ys=0,this.gs=0,this.ws=0,this.Ms=0,this.bs=0,this.Ts=void 0,this.As=new Uint8Array(0);;){const t=yield*this.Ht[ys]();t&&(yield t)}}*[ns](t=0,s=0){let i;for(;this.As[z]<=t+s;){if(i=yield,this.ct)return this.As[ct](s);i&&(this.ws+=i[z],this.As=Ls(this.As,i))}return this.As[ct](s)}[hs](t){this.gs+=t,this.As=this.As[ct](t)}[os](t){this.Ts=t[W][qt],t[W][$]=t[I]>0?8*Math.round(t[P][z]/t[I]):0,t[Lt]=this.ys++,t[is]=this.Ms,t[rs]=this.bs,t[es]=this.bs/this.Ts*1e3,t[N]=this.Us(t[P]),this.K[gs](t[W][$],t[es]),this.Ms+=t[P][z],this.bs+=t[Ht]}[as](t){if(t[_]){if(t[q]){let s=t[Ht];t[_].forEach((t=>{const i=t[Ht];s<i&&(t[Ht]=s>0?s:0,t[I]=t[Ht]/t[W][qt]*1e3),s-=i,this[os](t)}))}else t[Ht]=0,t[_].forEach((s=>{t[Ht]+=s[Ht],this[os](s)}));t[I]=t[Ht]/this.Ts*1e3||0,t[rs]=this.bs,t[es]=this.bs/this.Ts*1e3||0,t[is]=this.Ms}else this[os](t)}Os(t,s){if(this.us){const i=[`${j}:         ${this[j]}`,"inputMimeType: "+this.cs,"readPosition:  "+this.gs,"totalBytesIn:  "+this.ws,`${is}: ${this.Ms}`],e=Math.max(...i.map((t=>t[z])));s.push("--stats--"+"-".repeat(e-9),...i,"-".repeat(e)),t("codec-parser",s.reduce(((t,s)=>t+"\n  "+s),""))}}[ls](...t){this.Os(console.warn,t)}[cs](...t){this.Os(console.error,t)}}const ae=_,le=P,ce=q,ue=rs;function Ue(t){var s,i,e,r=t=>console.log(t),n=t=>console.error(t);function h(){}for(var o=new Uint8Array(123),a=25;a>=0;--a)o[48+a]=52+a,o[65+a]=a,o[97+a]=26+a;o[43]=62,o[47]=63,Ue.U||Object.defineProperty(Ue,"U",{get:()=>String.raw`dynEncode0146c05a3732ò{ÚbWt.á#û=}EfÎÄV	Ðë³w¹´ì_Y¹¬¹°[oc×ßow¬¼´ô0ÀýM¬~ÞD þðñ 'óù5Fý's"üsêuüµAÊ}*ê
Ã (¡ÒØûYG+»;Øï3ãJ¡>Âñ?ýG1=}3/ATfCyÃ%KøSyPNçaHof¤ÇfªÌÄLcèfª>grÐý9zã¢©Ôå?nìb%Æ5Ç3>¤Þ= |¦Iá6Ãö_%U¡6IN#g
èý0üü3;$ÝÄ!D^ = QãS©NiÈ\Æ®9G@÷íÞÊuñ^
¼õ¾©gfr.~o+¬öP,R<iL¤îþW Ç'¶FøVjî|Ò©qÂ}ðn]ÜPcO×,°Ë«VÐh"²P®àÃËìÌìì'Qj¥;Î¤.¹gtß~WÚ,H	ÎpvúâSvk_hÚÐ)ñ,cQÛª¬³Þ{©û·qdâÊÊ®i¦;YPªPr*¼ø5 ~î,	Z§ÆÅ=MV<HêÐÁ2û ×ì*#¬W÷>§í[= z¿q¾nþjë*Ó3ù>º HñÚáÐ¤çæ­¼ãW+ Î²ötiîq6²)ïÎ¬F}¾áÆ/ÈJ'êÈ\ít77ú¯pè¢ [
Zú<Q|Ül
;H5ôöÿa	òæðÏË º)GòÏm[´V)Ù7?¥KÓmõõspÔ§SÅ9³7@'¯êvC2s­gD6q¦Eõxâ'-å>Ìè>¢æëíwuß¯fiâüÜÕ-u1wýE Ø#J£°ÛR×±!pÅ»3EyZ:j/?íð$oþ[rúä:d#ÛÀpj#­»É¦Ï!éJq5CpvÂÛSÈ$F®ÍÞ¡»¸µFÚTì=}£Q°
úR+aËê½PëssëL8Be= 9)Ð4O­Ý#y2¾Úc= =}^np= ¿Ï{õ'F(u²à]¸OÀÑ÷£¼I¢ØöÖàØkÛõkÈ¶"£=M#xûüdô{x ëÎ©x´¸ 
RßßPÐeX©ÍNF,!ý^?(HÙÂçYïÏfq.£í1ÅY¿ ¨yUn°.·èç°~ß£iO+J{Ù¡ÅhþÀhþÝ]Â_@''3ËO {1bÐ¾ôàïþjûQÆ2®¤+Ý"]¹t~ð¨Àau¡¿KÐå«}ÇÀõ¬æ7Ð=Mp~½£}D²©]÷ªâÊ¥HÓ-Î[@Yü*< GBéu)Ð)ð#Eßí©}évá¼èâyyiÆºo6ÝndbÐÍí¾Dnöø÷BÊÚª×¸Ð2we¼rGÙR/Ì}<NjáÀ9§×= ö+µ.¥ï[ðxò}É¶7°ÛyeôíîåÄðìà¬9XÈiÇØÑ^BÆK½Æ½1
­£×ïSºiÂ"ñkü¬Ë>«6DÆ~?àþÓºÿÆiÁb»*îõc/®îí,.K3ñúÏcóaxh·ú¿ácè)®AÎü è#Ô<Õ®éi*.ÎÔO·©ß/×Êñ$îMþrÀ:Ìf£Tr¹qZ=M¶·²%®0EöØÔ6NæiH*ÎÕFõ6(ç=MU'ºÁ[ªeôÐÂþÔ]ôbuµn«ùËq¬qrßóöv¡à.eÖùÉòwåSb>¢ÉUà^óÜ¢r©'¥vÑs·^ÆÐ?'æ­Äjé²àÁÉÒÜbòðû¨#q¡PëÈ´lté|jÃÿUº{ýÓô'¹û<úÈ<3©µ£µü ôÁî1ÔDöó­Uõ0Sd°Ï&Çæ¶ÛÃbzfm­iÈz7pùøò¢wD,¼W>;è¼nªHäO¢Åë}~î[cÞOYÞ¶±qm6Ñ7ÇxG=MJ$^ÁlXÚö»Y¸1¬©æ¡¶8Xé,4XôÛ¶Á<þGvÑIôOÂÁýTx×iÍQ1Mb7ÖbÚ·&¿óYê!Ûiàtêj[w4(ðfj=M)EëTâ^ûÿÐ^Þ2ÈKAôYÝä= {Qtîthnä £¶¾Ø»ßX¹ Ü]¤ÃÞ·Ê<É¯hëÅ"ÏéP^³Hz´OÓN>Æ0P¢}­9),Ò¢ôÉ$ò2/¥àyóOÇH ÖÙÉY4ìÕaj@ÓÜ!cê=}¨L?ÊàýÜr»';É=Mª0/«) wKs¬ç%}ÂgÉV0
³	3­núÉçÜNmçÖoCß=Mjð¦ð©«¾uïÛÜyÎiê};)ãÛ]¹×ÆÎÔ¬?É[P	àï¸üñ¥ò¹²!D¸NCÉóÜoæo¡:¼À^]ó£Ã½5"Úðê®ÍT×~é3Ì¹Í2_£PÂ«+®Um²ª+ñï}UÃ¨fJçÕ!kÓª= µ´TBÂú²Ý¢XØ"[fe]Â4-±POmþ¿UmBåQ¨âÆx×®Ji"þçCîTjwñm¤³Ð}ª#-[h®A-&Kß,[Îâ(S$w5²ÕA-@ð;xoõ_8xwdZº,×7E_ÂbDfÿó24NîkºI=}½ú@:÷TÝ°5!aM¼3Â2Ø]ìZ¦$5qíq:±¡G4Û³±]à9®øÍÑüÇkÿP°N[l½îü1ÅTBN»¨.Ó¾O:iñÈæIí4«Þû"ÏÓ, ßÈdExEq³´[-äý'iwo½ÙÕå4!3ar'ù	Ýªä¶$QËÊ²ýGaDKWX3%Îz/0TâzPµ·ÀÌüüãÑõåÙ®ÓúA×tií/?ËQËÌeÃUcÛ%"yµ$á¿5áØóØ4ªpýa8ë»h×LihEg|·gnGHrª¿å Ø	¨A¹¯°RÑQ$Q´1\Ösoþ£u®ÑaNzt^vÚº·!ëþz¬ä%?ãß=}Ð¨­A_ßÁ5-äÁ4ÿ-äÁ4)o~×F6©ð.ÙB=MU3§&ù÷Ì6äÙüÑÐ_ò(Y£ôá´ÿ´ºÿ¯¹×ÒUÂþ±y£E|ãÝ&wW/{ªRÐ¦«ãKINmÄNB1ZtÈiµúpÆ¶gÂK]d÷£¾
ôQÕt¸¦ÍÇÛÇCÙw¸Ö;×ITòT´diMiMo\|ÌFiÜ'WÒ«H'WýWd_d§fFda= ÉÎüöóTºbf@Úñ®ígPíéÆÄìocn¶iÆsHxãÆffiHx%°rKªÁGßJªof_ 7VÖ_JªìYÖÿéÆK= ×qZ»ç¶ø®£µ³±PLJjÏ_Öx1= ÞÁDïðÆ0L-Ñ(¬´ÐÛåä4B;%Î4~ÜÌ¾±Ö õ·= É0èÔRüvË®æwå±ª3üA2gÐ=}æ _òrÔ»Òý±õræp ÁóC,/|O\·"qh'<8yl¯lÚ·ëyëi	,ôÖ½Æb¸æþÎ("O×ñ 6m lji¢¡ÝI©ËÁKÒý ãôOT8_ùãFF'5Q=}GfÄ_ÉÒßmÕrkùöpj÷þ7èÞhsþMH~ôVÏ]gûËÝg¼RÁ í½Ç®czÀ§Ùhê§ Ü$É>%{ísªß½"NvxOh-aQÖkRìlrt,Øº	¶êj³Ç(rZgIÙªyßlÈqöÓOy£èdO¿ÉWFW dÀlU×ÚÚy¶ÞMÉß/qyÃ«|Zx2Ø^<ôvX¯[h;²*¤¡×jRÊZÑÞÖÚôNb?¤$à= #=M;öoDZQÅM
ÒôE«§Ê«ûq¦3Á¢,Ä/E>´~ØxLÿl'¢g!* xþVwd¬nùÖs°¹w¢ÖÏèshÏh Ïµüà½¬}¦±YÍ¡hdÎ= ÓZu¦aò!EHU<V~¸A®kóiTQÛPÞÙÒTmzÉµb\|4Q§ âAH§òL¾Ô%Ñ°r¿¥Gó²0¨Kg3¯Èf.×cO¤"Ë1¼Ú8på3ç´ó£ÃàR!Ô%ÖtÍCò¨³­PÕ®ÿwsë¸´ÿç®¢^vðW¥ù =MÛZ#Ô5¯æÀ¬ý&¾ÖsZJznÛ¦x
\"¾Ï¡"¸"ô'wëèkM0Üsä¤s\d#2ºÈöIÞ/Z<Xü#MjÎËu*cú?=M;}CSÅÅI+\+aD@wBÓ.ÖçA9káÖöOâ=MøüñÈó(ä³GÀ;æÍ%*vÔ¡U/ihªqõ5à¦+û{»\â¼¸åØwÍ-ÄÙèÙ
eïlÐS$ý q
ñíOxpÅx'^:³
dbf }.Ã%Ðxl¿´a¹iØ}üÙB%´²g?³j~h¿¹µ63,LÏvYÄ[ÿ1¶µ²mBçºÙuµ);iØ8}7ÌØÕ´i?.Î*á!D\$ 87³jee×Â±¾/lí= UÕ§JBç= ´´EU¬ò¥RÂM2Ù¿±È=MvÃ(³±Wã¿)u³6Þ°X8ÖGoF*-	lîa®Ààq=MU÷OÞã'7j¢J2'¼KP@3ôS·í¹+§v¶)Øü$î¹\!ÍÏZ·Bpu°]ðÙHryþPÇAô'X2cå®¹®Wø(UcEDÈc 0ºP´#U<LÜiÒæý(INz©Åº 9G=}¨q'§9Æ!±ÔÂÁzbO,¹|¿,õhYdKVß|*"køºÏ4¯1»?rò¼hCÐrÔ-Ã|ÞÄõP1uy*×a¬ÃÄÄáB¸¯_ç=MÛ0ÔñvzFa(|Ïôqi´L" *Må=Mi±%ÿeÚf~¸G %ÄÌ|¡«ÞîqjR43 êtÿ­æ^¨ðGØeWn¡ík±Ô*C>:ø$ç¹vç¾ñ¼øÚoñ¥5<v¤Å4¾7ÁH¿ê§Äïß;­2'm§[Àï@a0¾ÔûAö¡3zø¼æ¥3^©Øå}OTº"»áÚnÚÚæ%Å.DålÝÂÎóúÕñà><mMÑÞcádÕXÊÅµjm;#Áb£mUâÅ&Z(ê¯= ¿#dr²Üän*(Bö(æQ<0XÕ©;bÕðt6n1bÕ76;RÕê<ÀjLÚiÉ¤ÃÒO;£Ø±ïÏÈÏY¹lÔ¯èª¨YQl4É{ÆùyOî!ZøOÁeÓ/¸¦À\w+ºJßtÞf+Î/¼µÉû«3~ßoâZªlUÙÎÇ	)¯'¶h£=M§TÇ	zZ©T-IÍ/Þ	b)¸òÎ=MÎÁW·r¡p2½Í¬h¨&U>wuÄÑ5¿oÕ±A5SYwk÷],²þÚ]¼¥ãeËÿsÕo.JãSgëvP¹ëÄZm
]X3
ü Ì3¨+8ìL\ZLxîZµPKõ!.øººëÍ<²qU¿Ád8wU6s½LAÆDÖÙÑHX<j¿ÿ8±aÅºiàOWÊ-Î¬h)Î¬h-Î¬¨WW
HWõSel2ÄÒWìèiw'èMìQlº¨ s}éPeÅÙT§ò Õià²ÔW­©
ØÎ©´_1ià>wuÄÑ5¿oq³Eãºôé»ðæÑ!Ò.§xËßñº\ñéO@dC~© x£ú© Ð¯:÷Þß$Ñ/Ò/A¨ÀÈ¶gÁÂÇd¥®ÕÛ8EaÑ³üïrZ|\ ç4 ³õ]L´Kæ·+!r¢"c+?â{Hñ¶×C)²YOy§òiwª+£ÜcøaÂ@Ä2ZðJ#fùxÏÀ= bdôÙtw^nyLàw&n­ ¼/At£¼/r0°LLyèéÁxèd¯­&Nn¼¦Òøumc©ùä÷ÈÒ+©,×qZ- i9VÑùô~5Ñ9·7òqtA(Ø±<ÐhÅðb¯*±	¨Ì\@Q³§Àáç.ß<iiãÕÕºOýÐ$Óî ¡_é.#ce_áU¢ÓÂrt=Mèí%}t|\ã\Õã³è}×õS=}u8{úv%Vo_ê¾­(Ñv=MÿüOÄ,pF¿.ºxC^ÌùÌãr5ÚÇXrÍþIuÝ¢ÛìÞáõ*,£´«½ÔÌ!ti  óhÛéô+¶%ì¹÷#ÈÞcósü§Èå²°tU³-ä8×·¡Ãöz;ùìæqÀÕõ^$#ãåQ¦|Õ,Z"{°,ã#g*Ê ó|æç,©¼s>¬¨îµ¼s¬T84Ü¾éôûê±Óü~ÑÙÕ¨ÀùÖ;¬Ñ])\µ¡½%(3¹<\±VI'ÖmÄ¨5<¾+¯Mÿ¥cÖõ[RæþöÉy	ùÖü-uu{äø!$j?k r:"´K0± [§\¼ð$t¼txØÿ$çX=}ØâXãáâ)!Dªåµ­l­>\lÇµÁ­Ù­ÙÐµ?jÕ»OÝ°CuëôuÃë±í*hI½©¥ !dápL²ÜQËÿýæö!KU=}¹
iöÒ³lz²áçáéÖ tûÍX·×'wÍéáûé­ÕüåFÞI®{§ÚoÇÜÛ_5G'ëþF"¸sÇe·7¿Ù p&ÙØ»Ú¡ïvíhÈügå°)+®VDõ=M 44÷×g#âu	'Ê6d42é+öñG~4	o®HRÔ71íKÁHCÛÅ=})Ú-*o¹¥+~Ú½0æÇâÀU¥=}ÌY³8þ©»Êr#QÜPâÇYm>FÅ3P°u U Á#O<<võÏ2T±Z¶ÔÆ/ÂÂ¿Hï©7ñ&\®ì$ÇpÒVÔeÇì-M;móm/¿ðË£Âñß[uºvpdÔÂ»4	Ê{¬Q¢ûZ.ri/L2
¤Ê0°±f:Ù0n	µÚiªåÂ ²	b$ùQ¹§}þPß}çË/°I«¶JÇoì+F®Þ¤Q+ M³ËÿZXóî¤\¦N{!lh*p¾òWP]åTÕ-	{/ïI· Å¶¹´O-'¶ÚlþíJMã=}ñ¶4
F ÿ(æ@MWï¢Ð0U¾dr_OÚì72JÈkþ0AÔ¤eÇìÔÚ
µðNúéüSºôÕªÀÈ¥dÇs"!Óä´áÄ ÏõíRß¡²|NÆ¤ÕØ
¯BÊ#ê!°ãWñMò¾ImSmÜ»PÒ=M®áÔu%
w'G|S½+ÞvbÍ¤Vý8¤¦oðÃ= Z°« |×­Öóê²²ffD¿ ðîRÛÖco¬êÚcuºç_§.d*"i-h/¾EL\Á}¤Ë>´¬	Óæþ£ê0ÔÐÄ_ÞÎr~´ñ9r-öÖ]ÜKÆ¯Å-$qe¿%Ñ=MØ¼¾è¤×<»êîi^ôüSÂÏÄgaiY7TÍÓÖ©Û~4YÂÙMÉï»Ý ;¸«fDF*i!JGpËÀÆ6¤øh¯ÿseqø÷hyègZ¼ |?´a³Í|«q³à,:rÆnÁ"Ò	Ó Öu|s{!çÔa ÆÐV:Tzæ&ËèBâßæÞíóaR²ÒcöÌx|hÕ«t*q«?c¡®aÙ´ÑD
áï¯Ë(å(Àg Íþ~·6õNxQÔXTmN-JÕ¼/ãtÃe5íz3ÀBx#)ÅuEQ=}+ÅO/qB)ë³äÈù~»¨.Ý_%¹ãnlj±Rm±RáâRáÌûxâp÷(Õff$I
×sé©FEYdÚÃh¤aÊ
!È6ÎémG-&£õF8ÀtÀ¯9¤ GàÎG²¢uñ-kÉ#És/tx¼M»Ücgòè-ïÆdÆP«p¶æ«O°© ¡lûÄñuivÖÒêYs´"rºvÍ3Må=MºøC<Ó/äfô¡ÛÏ$rëy!ÝêÉõçe6¹É¹3äWOë<[gµ»¡ ðGõ0Sú'¿);¤¢Ubò ªmðÀYs:(<à\¶¬£÷zü{	¯ûi%ÖUÌi%¯:ïbÙôkò¬Ü&µ+iràWKnÇòJ­ØÅ/Çr=MI4¼Mø´DTÆmaMøèÝä)³AG6hæ¥ÐE&Ì7ZÜý'ûfë2eÜÔ+Ó.-!¦ÿÛ:Al"ùH(6ãûò­É\zKããÓ{^þ¶?ð'ôtÏØQnY´½h£Ï&@®RîB¾Âæîµÿ'NÓj ÐÖ>ßÚ½S }¦E	©M²õ¯¥ÿeiþÊ)Oæ!-ÓÔ«ôÁ9Ä7¼ ¹»ìÉ'bÜN­ÉM	u¥ H½ú%ÛIYüàM¡ZªCÔ*ãõ"uÚ#ü&*ûõøÀÍ9åþLch×oßu%»toíµÆ¿W;îÉFØ¿u«Z^ÈVêßKaÏ3uD;ÅA½E+5E45­©»]DU¥D}E6ÅB?aÀÓN7bNJ=}çºèÐÁ9?FÎ±"§¡| "°M/¡²x}½v¡ö ou)^l[UEvã\iàÜñècÌó8(=}ÓXºkéÈ=Mî¢|¾ðÜÖz¢â9>ïO7¢½®äuû3÷õ.¶&ï¥ëhvTYúÃ©H²'"Æf,'ºR.?0ÇGÖuÎÔwò7MT@@¿.ìkÍ¬À	±tß[=MÁ¥T#/ó¢/'*DZÎÕã°ØðMÿÖçåKg·W&-+*h¶ù®Y¾v3ÙÖoÉï*:³¦L¾m2Îÿ×FtÓ®)v(j¾f°V³1^ç[û|l"H&Ù«e°ëYl?
úHaÄkÖjTicv¬Î¯V=M÷¡#yT?_}Uz£CÄ¢Åié(UÞX7û?ç¿|~cx°êFXO%k8Ìðkqjðt7¿no­ú*?°Ûù¤[/z åþ= vR¹þéN3åDÊø&ÿÆeÔ[[Ï}XÈo 4¾Ñ5*¾ÔZ 4X©(¯¶:¶çàFAÝçB#¹Ó=M$r¶Ö1ü]ã:ÂÇÇF>óÊæd¹Tµr­§öÅ=M±-[õÃï!9a4¯RëeÃo5»à|õ\{Û=}f5yf Ò1ÅÞÔ?{Ýò¢øÇïóR/ó=}¸¿$ðo+æ¨d.¢[À]vÄ¬>ßUHeô~Ó×³beoecâÑÛ~|ÊPÔßb5Ý39dìeÆá]3«t]ÃÇ¸..±¾ÀÒ­@¿n¡TiEx	v¶Ã¿îed®Ü	Qg=MGÙ[Ø ¤jñÒH®FjeÊl/÷ S&Æ¾éx Ä ÆKdóöd@A[óöþ=MwpØk/9?/ÆÍ{Ö¹,/èAVKqD-bì~/­>Þ6ÓÙÒ|>×I×{ºc(ê+» ¹À"wÓôÀ¾Ñg3¢M¸cú¦¢þT¤£MÿT¤£M¸c-Ö©Ú\B&.a¦¦°cT®-ÿç¸qT[@"F!¨ÌHü\ÿøAÂj8~±vÛ9okf5I5A@ì=M×ÂÈÒåÒµ~LÃ¶a÷MMÎ¾jÅã$>\Õ*Õä!8"Î*Ó3jýa¡Ä·auÔ$"8aÂÿØ8ï4"a!OÅÙµµ²';!¾C8Î*UüÙBC¦Qý×Âº83jÅÑµµ´g?>|ØÕÕûã*kûË*qÓ'çÂta$w °GJtH¦¢YÚ£?è"ûÏ¸kÀ×F-ö*Ìè@¾ÿ>b	kl¾Ò$¯YÐ}jK~hÙ_«<\/¤*8ê@
Ü)R_¬Køe>)é(i-i_{=}£)zÌx>aCNÄmeÑPò³ûR ÒµUØÀ¬ÚÈ³>|±¾$:6%wqNuàRom½MÚÝ¤¤×¸è¢e¤¿»SÏ8 Æ¸©[+,ÓT+ÓG+Mñnµôç$= ´óèÌh+£¥Un¤?= ÐÚY+ÕÎ6FÎZBýÄ@¶D¢&¢;Ä}>PU¤\=MU#@âÿáê¶Ø_yÉ$) ÝbfNÍ	dÏÝ"²m´YÖ·£>
-;¼kG ÁÈWzÄ·c)gAmíaeym&SGQ!åmyÎFëÀ[hÜEE°ÔárGÔ6m(¸¥Ï_pwk¬¡kÙXjË*!>dÉEÉÍÕÊ¿\ÈÚ¶²+?ÊkXe!Iö/¹s÷Sö #l%%lÅ ßeyt7ôí	úã³»¿Þ"tô¤¢ÛX£á#£û_Ç[üÿg
óÜ);Qqí;Ã¡½ª2T
,RºÞc!= ^RöËUÓ[°A'=}eå¤LoÚåiRÆ²á¦%ä²O&Çê·MìÑ]¶YöñMÕ.c8qQì;ÂKíC¹uNè?w>èHû×Óáüµá«±f= ;¬%|;¨¾Pmrbx%Ø¬t *× <)³ð­h) ©Qê%x×´¸>6-9ÜåïCÿê{Í%¡Çr'Çr¤AÑüõ¿¡7½=MÁau#ÿ>+·7÷Ó(1)¨ýò,.Ûw S(zÆï eimÇº t¡õP \Þ8þÜ)íVV¼§¡ÉFì§õ IO¸d]OÖ3 @OÜè¤|M1|ç|õ~ì®ËU½B"«Îu_ËøOºWz$·3×%DÃ÷%¶24á%.~÷H1°!Jç9E=M%E)*qî¢XÁÝðcxFrgj£¾ø ïS¹S¸ÉWnÓº²Çêº--ÈÐÜ@=Mþ5cy(,¦´_ìå	mgO+çíØÍÎeqKm¼Y{ÕDiÉô Ìgø}Î@Ü%ïèvþTÃý|"Xhsñïy2L3Í-<ç'Ã..­«CÈSÃû<£Ví#Ì>ð«Á	®.fn)dßèÝ§tL|rçéF<æ:y3HÌâÌPmB¨zÊ5,Ä÷7@éjß5*ûQu¤ù"9:ªØÊ_EÚh=})ãÑNÕ¸ifÁ@û7_ã-ìfíìp-ô:öò/¼>·Y]Ùry;{ÈM´ãí±eì®¬D¦±]³ÑÝ~¡ÛÃ0Âc5òÛg¹üÜÏãÃ:Ø¶Ù1-~¬³kÆ³=}ô0^bï( ;áQ>¿ÁVHÕR(´öÄB+(m«*bw:ªPP ß®= ÄêÑ÷·Î·ë5E-"ûx©D%ª­âJ/äçy·å^x¸©}ÛòlqªyÍèéèPºA yi)üÚ±ßbIÎÍaôzÐ$z^R?øAfÉÕ×&Ñyø¬a®ÈyQ.SYÌ/!°õûÔp&naýêEÕè4®å¥ïÛ×æNGÑ4&HöBÐô/ÖÆ \{t=MÞ¦~ÛjÀÇ#zPÖWF5ìÜ0Ûçy:ð^õeÿÿ%ð+¯Ò¼))Ò:v-¨äüCC(<:ôNíL<W·å44úÙíaßìa³ôå=}MÔ¯EkÏd0*õkÎ¨âU*sVó~eÒ0ì¦âý\nÿ´ t¶~l :R|ÅL!î,¯>wî»wjV>PÓÏ3Ûëuj¿¥4!/øs/RtÛÏ&D3u68
tÅgÿ½abÑõü<¯èB_}Ê£îö­h2(æßG!tÀÞcê8n0ß\tÆwaÊ>³Ôs±
TÏ(¾Ð2§{yº³·5ïåX¬ðv~,öäÈhuoªePÐ¦b*ùS×µ§oSù»§}ù×Z¬çêZP­3äí3¤]°¿nÉzZÊe¬ÚGçÿP¯RÊÃB÷¾ÆuT5bWZ*Ü¼*òÃMùTã.A.i+n>þM¡|ôfþM­Ù³¶Ê©Wâÿy>v»dD"#£©hC¯ñ¹|6@Ï[HZôI1OX.òW¹ëÿA;vÛõyÛEÐ+!ßøIé°$÷s¿Á¡84aÀNôì1aß¼Ó©iK=}×7WX¯ÚË?ü)ÏÏK];ºtÒt³Aµ½ì%.­©µÛâlvfKª|àr<ùÌÁ%|¢câ^ÃæÃ m0·qÛý|¢ö¹ªC¥S= 6Jµµ@Ãq[åP¯ú-máM¦y¸,Wç-º]Ü¾ÀëfhdÖ84&®pËæ(
T]]YÃRIp3Íõ¤§Ëîqa\ZV:¦XYQ/øbÑ«V$ÑÊOXÙ"ÿs#Ô=Mï¹Ê´L¯Iû§ß	aT!"íiÈC6ÜÄ±é½Ä~gVC¦ aªe¶"ä=M»fO¿KÍ:å1ÕUºÜÛRâX¡:GGÁòT_ ­¼RX*e.rÅØî§RÅßg*Ô¥ÈSÈcÇ[²+ý<ªZEø£6ñÑóè ÙÐFé%^%&Öj¢|ÈvØYüÐ¦Í÷ÀìÒ$»¡"ÎÓF$£úG)¶úw¾Z>ôÊ5,È)E©O©ECªoÀ­qpà	O~nàÑ#'JÈêæ®äÐÜÌZÐé¹B(hJs³Í>5Zî ¶ÙÁÎ!Î8è¿ÓÙ»ÓúÎõ_xÇô!0r²ªee]vÀ«O¿E×)o¦F6ÏRJÈÞoJÜ/å'Õ{T{_4óÐ³MûfZ{b×BöSÿo<=}%Ëï¨Lãç3õ{y	ã
å=}üATk 6Ä¤ t?ØOùñà© âÞG¿P#ª= T5>ïe4Î-ê[	LíjåÐððÊºw"v9XÂÝQ,¯A(ø:å¬«íäÅýn­Ã0+ºn@ùêA¯F>AìLE³úCÔsC<²/ÌÅÍ%vØ0=MtaMïÒ­¡.w;ÿãIq\]#ÿ0ó|¿zT
úCf¥s§·]k]óùAóéë_v
= ³þpÜÝ1pRL¯U[B9è³¤aða£ÛéÝlßßæåê w#ìñÜ÷@dë3÷ ÆëtÌ æ8Uwgé¸â&Ò= ®þáa¯= ®7A£ñm«
Xv;ÀÔ~m±éÔÈJOiMl&fjfDâ¸×a4|6©&)ù=}¡ÎTåflì{^.¸µòzÊÂuÜnû  ÝÄV¹Úsã:ëeÕõëôuC¿rûnûæ:§ÕAjnýàý³ÌaÈ1x+; ·ðüëÃdùW®ÅÓâè¿2¥¤>ÔæèáÂÔV­ò¶ã:è*¼	Tk]!×uéZ¤ÑvUA@àg:V6Ã#2¥~B±= $Vykcj.öþ¼³Uo'tàuh@9ëT-bë÷,ú ;T[Qóþ_à/÷÷8Öé|!Ï=M´n\zlµé¦Ù<Ùýto ÿÓ°Ðî(M¿¶ð ¶¨Ð<öüíR»úïF-J°þtê± Ip÷¡·=}0«âæm¹þ­÷¼ØÏqÏSëg»ã5g½ìô2ý0¶¯¦_>±[]cz[ nÛ¤éÿ=Mw= ðe¤kq~©Ló3:NÚíÐ.µºÕµ¹q(áíàzh ëèëhÞ-Ô*ßëýç>Îb»¼®~R¡>ÄK,¦§Yñ4'AÙ¿*sx»aR!~ãlbÃÞ]= \º¬Y7¯¢Nïm4¦ÍeÑeÉåj* ¡À&¼³oÕìÒÝ¦Îû= VdhÌG"¹R,bäÄôZ Û´t¡6*/S)^roÍtËGÚØÚ-¹¿zÜ±CÌm2úz#"ÑÂÙ}xýqÆ#¦NLËî^ÞíQ= A¿J@h6jø.t=M^ãT§à5à%W	?ÄîðH7ÜG½¢W6fåú;ÝúsvÞp£^Ãï4§VÎ%k®JØÄ-±ar~Tm«PÁ96XV¢
ñ_+]I<àÜmiµ¤¨åå= !I¢+ÔLng=}!}cÄÏ0¤½Eñ ä½Ô}&éû¸:°(¤mÜÜ© Ó#¶>]ÓÝ\isÒ:ÊÝìêÏ= 3QKí - rÏ	ý·óSà
\5ó>VÎKcGÖXæVÝ£v@â¥þÖóT7öE½­å³v½3bð´Ù¥½½´42Åõ©&~^*ÍbS¦6Êw40æÁßNosÄÐ7÷ÔøS3!µ2f$3:HI>'Í§tÕX~÷}Ê·(~÷âÑÏ_<(­+= 7VLÁdh^òr|Ô¥#xaÎÒ|Ø¤v(ùlytVýSKÈf^_~2ÜñÀå«Çn­îp²­ULÇÕN{K*dPÇ¾«~ÝR&?¼màÙ¥yvÔ827ª0Ã ô3®rÜ	@îÙ,R%ó/l³egÉ$_A¢Ë#¿¨«²ÿ÷+Gøí4ÜY= õ</Î*¬¾ýù~ãö8ûÔ*øsðAÙÀ]0{ßémZÕ*Õ@= wÅD<8^ÕQ.<ýlpàR9Ë ÷Þ)ËkÎö1¤QÄ~
K· ¢/ðúý|&õ«>\o22¿fñ6ÿÃ&/ßW¥I"òRDðÂEI1í¨ÿj¡lÝþÓf.Ót¬Y*|&ß]ä¡Ý³ üelHå9>5òûÕÇ 6UÏøSPx0ªú>'0¾].oÏKs½bQ}¹ée_)]nÀ.¤jN6ÈÉ¯giHÌhÿ(ªò¤âmM{¬Þs¯_}IÙ'	XÔeÜ?POA³èü9ÖÉðîX!ì[tB¹qI$åÛÝÊC­t]äWãæ{Ù& µöàºû= 6ñ)£BT	0ÕÛ Å\Arò±
!y§¥ìáQ4ÿ­~+F¢\jæÜ'ùH0ækÏSNfJ|]7é²È å_Wx3= -5ô·´þA]Q:»t h=M^ý®ûÍp¬²¹¢²´¬óct ' ¦®¶7ÁYÙ¼\os\DÂé%ÛÓ ¼+ ×Ã×! jK5}6
!!xñâÜq³wö4æW<DNåðrüèòmÖWÊCëV4TV²^*3ÿ ²^+ç·Æ&d¶|'!$9sª¹ã¿ÜóBýÒk
ÕýêpÞgeûOÑ,¯Ë:,¯câ|Oì+ÖnVÇ Éå0TCk#(f<>:º#èÇ{ÏE,Z4}í¶¥º1Yâ]·= ½·= }ÓãéMqò:~äzQÖ!"ù¦~	¹Hû$ä-Z´ì¶%'Kí6Å	¯P~Q'ÑZ¨'\k	ZÄädÒ¹~qj%cÅ,6ãÄm/tí$YãeîSêW¬Á¨êôLW8ÕGô6t56 £ôtÞpáaÔ°äã
ÈÚ%¼Ø­ÖÏ¤ôJ">$tS*8W¢= æÃrÝ,
=Mº¯BÿÿzmnÏ¿º¬,	¸´íî"ö¨C½Õ­6µcCc3_V=}úvOrR¸ôøî¢qøýu¸!Ñì§|ÂW_0xð%@õaQÅEÕñÎØ!Nè$!i5¾^Ü-ßß?V¬¬¬äOy3{,Þ©§,\¬¬¬¬¬òðôEÚ|ÒÏ3%;ÃBÜx|h£·¯ò;¶ £ÅeZßÛ	m-Ð:¿ÝóÔ	]h×ÊTb(WA{¬
äïyØó¤®3ù²tú+|í¢n ËüÜÊ»®2Å»(tÜ
xi¡*kæÝ«Ä_d$ï¹Ã¿²5.>]0ésC#ñåìë7IdÄêæ7¼pfLq÷é+,Ù9,·4 ÈäV©Å¶ín°ª+Ôú*³Ým$¼KÈc¸ÈÍû£Ï6wx'Ê[-NñÊuWN¥iòYfÂÕö>W§e'­ÊCÊ¥WTVÄ~>Y'V'µÊ	ÊÅW ÿsú3bí¼)+õ*<ÅÄ¢ût[Q)8ÿ²~y¡Ï°±«?©ÍµøG½Í	GÃW.çÆU:¦½UJ:_æAI@ZÃGÃH.¬eI WÆôM:gæ±GÃF.°5I XÁÆtM:tæGI.¨uM£N.æ9Geº2¯ÀÛ8BüÄ|á©Ùa
:TÍWÜ¶x7XÔ®kúNMjbÚöÏöp§[§hâÊÊ÷Êwiç~ðÉÀBf_¤ðÓ²Â£QíAòT ©C'p1gý¼Ä¨éOxR+_¨Ö*¢×ç.Îq¿ôhpÉ»{W|Î¼Äü©!:1ò½î/«´·£p°Ó!ð®Û!p­Ë!ð«ß!pªÏ!ð¨×!p§Ç!ð¥ä ×jq dÚ.$v½ÖuåPH[î¡àú'j³§· ¿!/øW{*îÁ0pM0Q$ë(Jü·ýÉêÌuûçëè¶³µ{Òé	®Å¾Î}go0ô°îirµ1"éÙh°Îà\Ç	;ûo=}w1ÿ]lkÚÃO«sGkï´Ïmõ(ñ®Ào»i²3¾Ó±;2åÚçg¡­è©±ØÂb¶¬C*Jp¿ÇpVÀQ±g:=Mãñ¶2\ªXdY.ô"Û++.U'ô*÷ejø?Èúo®OVËjqé¨Ú0°:x¤õ èËªÑ²áØ²ÐpfruÂïGKºÍKæ¬Ùà-ðâ%Ä:qaµ\±:¡Ì&ü ó7´¾ý«!x0üÒ sé´î!x0üÒ sé´î!x0üÒ sé´î!x0üÒ sé´î!0ÿ	§íküÑ=Mà½è÷;»ö£ßZ!Ë±bü±Ä=}iÂ9äSþ.@R	GÃW.çÆU:¦½UJ:_æAI@ZÃGÃH.¬eI WÆôM:gæ±GÃF.°5I XÁÆtM:tæGI.¨uM£N.æ9Geú7ºql!ëå,®µäS¨@NÍWÜ¶x7XÔ®kúNMjbÚöÏöp§[§hâÊÊ÷Êwiç~°J;>½'ëËÂ4àá¾m7·â7£= ÞýÜT"bL),x
´äê.,yZ#Ho=MsÚh#ho#s¬ö´Ï*ÜÐ¾´_5ÀTz	Mn
tÛ»/N{&îtÛ½Oý!"§]·¡£³ÛºGý?"w-·¡Ûâx$´-Vlã 7_áZÌ/´¿ð|V^}Ý¹cÖ²Ñ1ZÓ³XÿÛïçHáï°â1|× {üÇsø$à[§ë¡;$å UÐN(ì#©=M²dá SQø$Á°ìuÀ)2_6¹1l¹¶mlíag£0HCY¯óÚP²#LNÞp_T« ]¯&5 «X5ÙÞ¸ØTë¿úÑA¹¸q»= >êd$Ìx¶¾\9ju	{+²Ö¹ØÜ|ÉB¸@ö\<ÂÿÇ+Q¬ ç-á¥\;£Ë¸	aÁ9*÷$7¬·=M¡ò­+¨W¡*\þ\ÏüÝçï¥ÝinÀ:ÜüX<Ô¶|a·Ó[µ]ñ°Y±°U1¨Q>_§å ÄûÃI°=}LOõkbhÔ¶Þ6À¾Içiß¶'#ÊYN5gâ¾e'j4å¶x=}~ËAmâCY)DOí¹EÊyþÅß"Å½!È#Úaõ#´ìz~%!²±ñúê|±Eé dØ^FèvNªã«²!¡²=}Ó-õ03½ÉÄîDt¼es=M	ÂáúH^¡«>¤Èµ*>¤Æ*¿>¸TòÈÛ_öXShí*~ÏbIq×é¦k¸JòTÉÛgöXNhMªeÏ2Kq×¦køa"òÉ¡Ð»¶÷Tto~ëM=MZ1&Ö«míÌE÷ã¯ûDAè2pürýçæëm´M^±ãy1¾,ª[¼ÍÂ:k'BÞ½'òùQ	ejðði!u	Ç_¾»s0ß¡NO£JWí¶ýoÈL'´§d4LPï)·g
´qÌ=  Óa¥m@mèQêu_êÚöHkÀ,ò·X¤¦²ðÑèáÀúvæÆ5v¼»Y¡.åÖ áùØYÞà6âsupû0>ÅÖÃÍÄê&Z³ÛwØ(7ÖÖénõÍ*;)IN®sêÑýÔX=MqðøX½ò)oö7nG¸®Ä®Üª9f>Hånbºl©fTy»_ÜÿR¤Wµlò¯5Ô[òkº}xr¿¸Üç_Q)å7äÎQ)'aÞVÖÀNë¤K»sR·7V+¶%ø1=}þZ¨» ôð;ôÂ%â)9«Íàò
-lDEBzÎ= }=}¯6(sÓ;yÐÃózvO¨·òV_¸ _ßª´ö8HýíÑ°¸ö ch÷ç­ã?¡ÛtlÖý0´áÂ,LÄÞßAÄÂÜ*Ø{×¬Ü,,LÔ_´=}ÙÏùs­Q	orò=MWT^,-tóà. MÊÓå7Íê´>­¢HÏQ!Ûühî®ÒXÅóPÂf6ý"üô4­QlçP¹wÇÓe;vªüRÃvè ÷æUlÈMÓrö6®ú)Æ³kéóáûÝ.= ÙÉ§á¶lÖB*RÿõëlàGÚDfËþp>æ?®Øv¨ý+ä]'sÝ<)Ê¾¨Þ;µÒtø~³}= L#_¾ad-3§øÔÙØDØ8Õe|áÜd§Ý^P_Øy@]§:Ì!m1U÷ÂnNíòÂöór=Mì²=}¶Al3Ý¬BSª<ñõ½ ôÛè.¯)T1ÁüÒD-P|üí4wÀ?¶ÈjX#
éýùíVP(U¼Ãsyìì1á1<û*aÛ³&ÄUØZÍUcÈSïÖh¦ðG$Ðï[n¼ßp(wâ±aÃ·÷ÁÃª³9H?8 :ÌCG÷=M¤1Õ#×å!Æ©õg!ÒJºB÷IÃ	ämvèý¶iï	ÊÕÚÇ.µ^= x>Þ;óÁH¸w&CgezÄ¯XÝîÖØGÉGð¿2Ò¥ujïßÚ= ¥Ä5cØv5Òyõ9I$ôO<"½!t.0Òô6ð­ßFÄå^Íf&¨(ØZj
ÎÎEV(7ö¾F76Á4×,.xs)G(×Ô]8e!f#«øøð.÷ª«ãJöª¢2#JH©G
c"AÙ( û¶ (ÝL ~vV ½7a*¡¸ïB?ÿD]ý·øp¡,mÝªàÏïÇ9¥ÕpUjB Õr¨@!¾ÊË©èþ(ØsÈ*Rffºû¹)'Ø¼gâG|m¹õëg2ÛÒôÚ³¬M*8íc "À= 4 ¥-£KçÀa(È3çJ°ÊLïcZîKEcÀÌ\¥æ³M{}!A¼J£1B¢ÇÌßyÚâù#>¬M=}ÄxP
¥"hüÖ\ÿÖýÈä	®\»¶2NÈ¦«­P£Îña)LGëVôÈ´~5ªI7Í Ãß)Wn´ö°]vjù¤06Ï kxjÿ*Ï¦uÏó%íóR»Q[¤E.¢¹åð8zÈÀvy@øÚu8+*m¾õ=}¸Û±¼ÊíÁq+ð]}â1À	Ë´Å#L'	Â8
ëÏUrÁ¬]Ü3ÊVº^Ææ{"XÐ½) k7¶s1õ«ø¬MîË*ß@XýFÀwðÉØ¥+A
¬Ûkùö3ÍKû¬E DÕ(|ðnÌßâ¡¬Æw:²åb~*æw®Hæë¬J(FR6òÊ5AÀ"¸¶û 7|%6hÛOg¥HØJ8/QÌFRzll¼òäfç)2aÒ²,fëE× l«vVjp:¥w~¯/çq
^²«.f(Çkýh3-d7N(.)ºÃ)¼Äÿ£CEëD±C½@¥;1%¤¸1ý(Ãíg6ÄÛpá¹z²Nx?R%a8*kÓ°H<	_â<9dÖôÿÑÓ%'Âa3C¤EEMFYG2DlLFF¡LFûSQûh¬§FFFFFFFFMTObaX[~|wjips¶½Ä¿²±¨« £&-4/BA8;%
	ÖÝäßÒÑÈËîõìçúù =M!"E>7<)*30ýöÿñòëèÕÎÇÌÙÚãàmfot{xe^W\IJSP¤µ®§¬¹ºÃÀÏÔÍÆÛØáâ÷üþóðéê?D=}6+(12# ¯´­¦»¸ÁÂ¥_d]VKHQRglunyz¢¡¼·¾Å°³ª©v}hkrqLGNU= cZYôïæíøûÜ×ÞåÐÓÊÉ$,'.RÉèQRFö(§ü³!ü³!üü³á½ü³!ü·8S¿9C=MUFEOI·kGÉØ¸sïfêÚj ®sæ:ÚtOðïI«ëHJS+ÆbÌÙ¶ôsÿh-'sÂØ8c¤±¾N=}ªdrÜûøH¼´J1«èÇv£Ì®_pLô¶ZT¯~¡í0J¢Íá»ÕÌ&£ÉÑ¶$@å)UCÓe7ã¤¾Yõ/ëº\( ¦£³Æöø¼dUÁ±q²õsûOlZÞT±tõ{Q.à)¦ÓÆEfpAÅbÔÁrÔ5wP­(2¤9¶ ~÷}(,$!¶¥e#þù;= ¢Õ±Áot5kN5+ÄÕ9S]?âÅ6BÙ?Ä+Bu:kÐÝA|$+¡ÃIÕ)­6e	É£®öÓûWz,j= µa³Q3ê3üÒ!¡U2wê­<ÛÄ]Á­/Ø#÷1º ­óJÛéÑ0¡ñãîSúy°²Ïnÿ«úzÚP|²sLé\Ð!EJ¾ZÊ'¯VJ&OTÈFbHï¾SuÈjÂ]ÈFBbÀ7µDNF}çTeËfF5-VJ&x¶Ûa¶{NH¶U4M%ÿ[JGþO)ZâT¶tNH¶\ÔJFDVbðGFFC<½í_xgJfÊÖVNOgJfjyNÊVXHggÊNÊVXHgg2%¥EÅÃEB@	dÎfAÎ¶W·SxâiÏ~íî7M= ÂéÑ|åèÒpn6c¸xh<ò&ÈY²'ËUþùôÒ§ÌKYyzÜ^xnR¦ÆBçä/æ@Ô®è×¯ëÓyà/þìô/ìÍaÀ1üä 2ðt.æã¹$põè=}ð>(Ù°?+Õñï õÐ¿,ËX¤qñúÝdpòî=MP¾&EJIFæNVFóÃ!|ü³!üßÓù³!ü³!ü{©ÏZX&ÊXR	µ6i^F9vQ,È[>aÇ>Iâ	lP´¦}¾IÕöIÜÉi¶P±|rÉË¦I*	sþQ&wîIÛ6F$ÉtQ¥yÉÝæGÔÉ¥&uâG¶StÈR6dT6KÀæHÉLÂðCï+hp°ËÎ´¡³èüÎ6Î÷ (ð¼!Zq×@Ájõ-Eh×;ã@o¸çÏbì ¯Rèì±ÓÃ)ë·Ñ@Ô°éWÓp±òéÕà}:èÝ¹Ì¬m ^£BÕDBJàü¨Å©9 +è¼[Ô£°Í<n<çÃÏ4û9wóÜu,Ñ§øwE ]ó|,ò{Õß°Óúh)Í y#B½YEÒ1D.¬(KD¡ýc%ó/Ü(}Íþ±"¡íe-qã¢ôñï«ºÄ()çÉÕê%êï®y®kÓÙÜL§vÀ^¢ØÔÁÉÂ¸ö«Dvª*²8'6×aÙíÌi	Êç$µÛ¶!jY4ÀÀßJ>±mz;°ÀëÊÓDg7à>5m DÅÜ20Ý:±Ï_Cå
:OBzCyË[S!ìY.':d¤ìö¦³ì<$?j­8ÝÀÃà2ïQÙ0v{¾Öxa5üu)¡½ÔÓÚ°¾cbÓ´õ¦¦ªxÞa{ÒwîaCM¥F5°úUÆêXLT&	øPû=MnoäèÌÏ£úoðéc3íAoúå¨Ao~ðíìîÔ£~4èÓ)t ZD$ý&3DýOE+jQg$KVGffÇFWFr'¾|O"PÙÊüXÜW´ç»Ê=M½§fdi´Ïè_WÿX[Î¤*ssÐjRÔ4jxØ6w¢ÎæÚVLX	WËÊãMÊùð¶bXÎ-=MãÑÝ=M£ÏQ
uÒ=M((7A(&>¾½"Üãäï§Ã§kray×/§[øªMrÎz÷èîFóâ¬çÐ¯t0VðÔ<ÈLaïL ráµ^óRµpL= YXi¨ww5¨âÒïw~É=M¦²
Rw-âä¹kmf¤n¸¸(Ãöþ2_ß¯= åëBØrú«k¬¿xQy«Uxçòðr¬ÚVÆgÑRÿÊÊ.KJPaËLn.É¬'óº±Ì}ÃLàdØtîë½¬=My¾_:sbÆ£ü¶
²]­N=MÄLÓbIÜ)©¬qý¾ØÊJuµHQ'ÏX0X½­dä¦8üjiÒjÄ8ÿj¿8Û*jrsßâúu_0¸mÕ*!K)K= D]GË¥ýOXKdÄg¥l¾ÍJHYåEqW¨FÐ
ÿ·×É~êWÀv¾·Q·\µNºÇ´Ë÷aÁ	jgkX­Î¿ãdp ôÑ<µ$4/ü½aÃáìá02\'\Z½ñøññ±3ÊBæ{Ö0Ó¶zB?/¬jd¿¹y\·ÅÙ¨YÈº]5Ñ%ÂÁ5@µÁ"CCø~4«òqü¼e99´3´¸ûÏßè¤¾õáÁvCÐÂ\£0u{YËÆ²zÎ|èRêwü^sºCUþ*R±Ý·Ý}ÁÍ»Íùÿ"ÖyJ+ê¹÷?â­$9:9à<âù]Ë]«"Qôû]Ö2­û­0yrz1?_ïj}³,CÐBþ0ý= ÊcSì0ÈLM´Éf®JTìïµïýê.aI¯¶ ªépã»¾át_ÞÃÀÂãgVâJ~qqCÛLÍ
ë¶]Þc[||
dGÈö\H0UK@ÃhUï¾òp©ÛÝm/áÃÀÂ
ãfVbgck?Ø|e;j4óé¯X3­ÕOÕØÿ=MÛI¢I°ÕiC®±CûGp¾¤qó\;	A#ò>=}sPQå>UÖ¦V,O«X{'ØNa§~ÿè?zÊðir×O}ì^P	¾Zw·ÜrTÒ½Y¬s²Êéiøl¸¯(X$HâuLÙ"lsÊÕFJQS/äRl§ÙkúW¼âÊy«ÔeÐRS7Sk-ð8¿Ú¢5®AnnÂúLÔ¶ÕÖrYÆÏÇÏ6JÉi­Ë¬ðªÌ³Lz_áêâ*àåQOÇ-= d{ÓðzjQ³Qçk¿Â+ÂÄgøýt+á8oK$<{è{>°- |iLãýßûúÓø¡²uX['øX¶ÉÁÉ
øaYI5|b:2©4U°Ï¬Ê-²Í¸Í±mLîT	{Ì·,·ú©Ü¦|RxU§ÍÛÍ£Í>|*ò4òæµÿ&óý}Î= 6Àoö#n«ÿK"T"Ìµ_´¾ôyõé}zk²æñM¬ £TDi*ç4ç5Wó µ ·Á5¡ó>cY2´Ü}¤hõºõÂu¤ÙÝ8"!¯ÅhÀÈ½ |½á#8c>X>HÅ}Â:Â¨Ä°$!$eâõ:Â
Dí]·ÑgØúb ûa:LzbÑö´üû²3,ÑlÛnf£l/ôn5ÈÁfÓl9¤Ý©q!ÅÆ'Èæö·£K=}@a±\å)Þ±ÆmÅZVaþ;VjkmTÃ CzQú 2s]A
êqÚeeËjÐ0öZ_¯BB'ºS9R=}%Jl¡ÿ½æÏlÿ¢ë|1eè÷_<s4ÔA¢@Y´mz tñ |CqºOü@+¿Í}Õ:U+]¶ï6ãñ¾ñÄI	 )}9ÂÛ)ù±Ë­ÿh|ÈáÊ×ØsÐô0´6¼JwLßÉ·i
ûù$%K­¸d¯âÂå0æ|¤®ë½úv¨ÂÇ=  ÆÍðë8)ð³ØäÉàwüe´.&?T×øo­×*è¨öÀVÂT÷= o~4^./'I´·ýëx?»S3NCV:p¼´µ39nU=M/ØPëÀPÂU?	~$BYDí©ò+¯7ÕisìL¥N]äo\î{6*µ),>¥ÔôTÕ=MY>¥	£SÃ×ôÚÅÃ0:UÁ±ç#%×59G^kPÒÆÞØ¾ÉgjI[©~%ä2(¿~Î= ãÍs! 8ÂYFK«X~I= k_gSËµiM¼[©µ¸#=}:ÃMB&Á.ÏêD¢;XôG0nÍR°Özuî²6dªe Y7¨ÁÏ±á=M&!¡úº¯D ì3³a%Lcëd§ê¹Ò~9ºDýæF;sA£%ÿä÷¬EÀÿ(CåÝ¢=} d_ezÔðª_ßÂòª,Õ?ùÑ¬Û°p\õ úèO´A+[;CtS®0ÃYZË Ûcßyý=}4y/?Ã w=Mâ¯[~ØÎc<Ùç:®´þÖkÓ
îï ÏjÃx½ð¶úìUñÒ9Qó±b¨I\@ÖÃ"U¯ñÄëë§úáõ¡ce?½1U= ½ÞÓh=MLH¬Å{/~CVròÝäâå ÈÕð~Ûï¾$·-¬ãov[enqõr±tõµ$/3µ}tD 6=M+Ü,3Õ%ÄSDÁ	?m;õÔ·­t>ÿ¾¬ÈS±uuµüuÃA6 Zúw¿	­CVbb1gí<Ñc©\ëfû~ó²¶ëîçE+
,3&!7ÜÆÑ¬t¤T¡RusJ­sã½Ç\fÄ%8Æµ%ÅjÌaúÒO
FÿG×'îfN>=}ubsÇhÉÇ¢YZQAE	Zè·ÏNÖÁKÐR?BÆ¢ÅLrm°ªfýtkø¡~wJ= XD}rqN³ÏRC=}nW
iÉSÅG`});var l,c,u,U,d,f=new TextDecoder("utf8"),p=[null,[],[]],y=(t,s)=>{var i=p[t];0===s||10===s?((1===t?r:n)((t=>{for(var s=0;t[s]&&!(s>=NaN);)++s;return f.decode(t.buffer?t.subarray(0,s):new Uint8Array(t.slice(0,s)))})(i)),i.length=0):i.push(s)},m={a:(t,i,e)=>s.copyWithin(t,i,i+e),e(t){s.length,(()=>{throw"OOM"})()},d:t=>52,b:(t,s,i,e)=>52,f:(t,s,i,e,r)=>70,c(t,e,r,n){for(var h=0,o=0;o<r;o++){var a=i[e>>2],l=i[e+4>>2];e+=8;for(var c=0;c<l;c++)y(t,s[a+c]);h+=l}return i[n>>2]=h,0}},g={a:m};this.o=s=>{t.o(Ue,s)},this.u=()=>t.u(Ue),this.instantiate=()=>(this.u().then((t=>WebAssembly.instantiate(t,g))).then((t=>{const r=t.exports;var n;l=r.i,c=r.j,u=r.k,U=r.l,d=r.m,n=(e=r.g).buffer,s=new Uint8Array(n),i=new Uint32Array(n),(t=>{t.h()})(r),h()})),this.ready=new Promise((t=>{h=t})).then((()=>{this.N=e.buffer,this.S=c,this.free=l,this.$s=u,this.vs=U,this.xs=d})),this)}function de(){return this.Cs=()=>(new this.Ss).instantiate(this.Fs,this.js).then((t=>{this._s=t,this.ks=0,this.Js=0,this.ys=0,this.Ls=this._s.C(1,Uint32Array),this.Ts=this._s.C(1,Uint32Array),this.Ns=this._s.C(1,Uint32Array),this.Ps=this._s.C(1,Uint32Array),this.Bs=this._s.C(1,Uint32Array),this.Is=this._s.C(1,Uint32Array),this.Es=this._s.C(1,Uint32Array),this.Ds=this._s.C(1,Uint32Array),this.Ws=this._s.U.$s(this.Ls._,this.Ts._,this.Ns._,this.Ps._,this.Bs._,this.Is._,this.Es._,this.Ds._)})),Object.defineProperty(this,"ready",{enumerable:!0,get:()=>this.Rs}),this.reset=()=>(this.free(),this.Cs()),this.free=()=>{this._s.U.vs(this.Ws),this._s.free()},this.Vs=t=>{if(!(t instanceof Uint8Array))throw Error("Data to decode must be Uint8Array. Instead got "+typeof t);const s=this._s.C(t.length,Uint8Array,!1);s.L.set(t),this._s.U.xs(this.Ws,s._,s.J);let i,e=[];this.Es.L[0]&&e.push("Error: "+this._s.P(this.Es.L[0])),this.Ds.L[0]&&e.push("State: "+this._s.P(this.Ds.L[0])),e.length&&(i=e.join("; "),console.error("@wasm-audio-decoders/flac: \n\t"+e.join("\n\t")));const r=new Float32Array(this._s.U.N,this.Bs.L[0],this.Is.L[0]),n={error:i,outputBuffer:this._s.v(r,this.Ls.L[0],this.Ps.L[0]),samplesDecoded:this.Ps.L[0]};return this._s.U.free(this.Bs.L[0]),this.Is.L[0]=0,this.Ps.L[0]=0,n},this.decodeFrames=t=>{let s=[],i=[],e=0;for(let r=0;r<t.length;r++){let n=0;const h=t[r];for(;n<h.length;){const t=h.subarray(n,n+this.Zs);n+=t.length;const r=this.Vs(t);s.push(r.outputBuffer),e+=r.samplesDecoded,r.error&&this._s.B(i,r.error,h.length,this.ys,this.ks,this.Js),this.ks+=h.length,this.Js+=r.samplesDecoded}this.ys++}return this.Ss.O(i,s,this.Ls.L[0],e,this.Ts.L[0],this.Ns.L[0])},this.Gs=de.W,this.Ss=de.I||r,this.Fs=de.D||Ue,this.js=de.module,this.Zs=524280,this.Rs=this.Cs(),this}const fe=Symbol(),pe=Symbol(),ye=Symbol(),me=Symbol(),ge=Symbol(),we=Symbol(),Me=Symbol(),be=Symbol();class Te{constructor(){this.Rt=t=>{if("flac"!==t)throw Error("@wasm-audio-decoders/flac does not support this codec "+t)},new r,this[Me](),this[fe](de)}[Me](){this[we]=ge,this[be]=0,this.ot=null}[pe](t){if(!this.ot&&t.length>=4){let s="audio/";79!==t[0]||103!==t[1]||103!==t[2]||83!==t[3]?(s+="flac",this[we]=ye):(s+="ogg",this[we]=me),this.ot=new oe(s,{rs:this.Rt,ls:!1})}}[fe](t){if(this.Ws){const t=this.Ws;t.ready.then((()=>t.free()))}this.Ws=new t,this.Rs=this.Ws.ready}[ye](t){return this.Ws.decodeFrames(t.map((t=>t[le]||t)))}[me](t){const s=t.map((t=>t[ae].map((t=>t[le])))).flat(),i=this.Ws.decodeFrames(s),e=t[t.length-1];if(e&&e[ce]){const t=this[be]-e[ue];if(t>0){for(let s=0;s<i.channelData.length;s++)i.channelData[s]=i.channelData[s].subarray(0,i.samplesDecoded-t);i.samplesDecoded-=t}}return this[be]+=i.samplesDecoded,i}[ge](){return r.T([],[],0,0,0)}get ready(){return this.Rs}async reset(){return this[Me](),this.Ws.reset()}free(){this.Ws.free()}async decode(t){return this[we]===ge&&this[pe](t),this[this[we]]([...this.ot.ps(t)])}async flush(){const t=this[this[we]]([...this.ot.flush()]);return await this.reset(),t}async decodeFile(t){this[pe](t);const s=this[this[we]]([...this.ot.parseAll(t)]);return await this.reset(),s}async decodeFrames(t){return this[ye](t)}}class Ae extends n{constructor(t){super(t,"flac-decoder",de,Ue)}async decodeFrames(t){return this.Z("decodeFrames",t)}}class Oe extends Te{constructor(){super(),super[fe](Ae)}async free(){super.free()}terminate(){this.Ws.terminate()}}h(Te,"FLACDecoder"),h(Oe,"FLACDecoderWebWorker"),t.FLACDecoder=Te,t.FLACDecoderWebWorker=Oe},"object"==typeof exports&&"undefined"!=typeof module?s(exports,require("@eshaz/web-worker")):"function"==typeof define&&define.amd?define(["exports","@eshaz/web-worker"],s):s((t="undefined"!=typeof globalThis?globalThis:t||self)["flac-decoder"]={},t.Worker);
//# sourceMappingURL=flac-decoder.min.js.map